/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import repast.simphony.relogo.BaseObserver;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.factories.ReLogoWorldFactory;
import simphony.util.messages.MessageCenter;

public class ObserverFactory {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(ObserverFactory.class);
    private Class<? extends BaseObserver> obsType;
    private String observerID;
    private ReLogoWorldFactory wf;

    public ObserverFactory(String observerID, Class<? extends BaseObserver> obsType, ReLogoWorldFactory wf) {
        if (!BaseObserver.class.isAssignableFrom(obsType)) {
            throw new RuntimeException("Second argument to ObserverFactory constructor needs to extend BaseObserver.");
        }
        this.obsType = obsType;
        this.observerID = observerID;
        this.wf = wf;
    }

    public Observer createObserver() {
        BaseObserver baseObserver = null;
        try {
            baseObserver = this.obsType.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        baseObserver.initializeBaseObserver(this.observerID, this.wf.getContext(), this.wf.getTurtleFactory(), this.wf.getPatchFactory(), this.wf.getLinkFactory(), this.wf.getrLWorldDimensions());
        this.wf.createWorld(baseObserver);
        return baseObserver;
    }
}

