/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo.factories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import repast.simphony.context.Context;
import repast.simphony.context.space.graph.NetworkBuilder;
import repast.simphony.relogo.BaseLink;
import repast.simphony.relogo.Directed;
import repast.simphony.relogo.Link;
import repast.simphony.relogo.Observer;
import repast.simphony.relogo.Plural;
import repast.simphony.relogo.TrackingEdgeCreator;
import repast.simphony.relogo.Undirected;
import repast.simphony.relogo.factories.ReLogoEdgeCreator;
import repast.simphony.relogo.factories.ReLogoImplementingClassesFinder;
import repast.simphony.space.graph.EdgeCreator;
import repast.simphony.space.projection.ProjectionListener;
import simphony.util.messages.MessageCenter;

public class LinkFactory {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(LinkFactory.class);
    private Observer observer = null;
    private Class<? extends BaseLink> defaultDirectedLinkClass;
    private Class<? extends BaseLink> defaultUndirectedLinkClass;
    private Collection<Class<? extends BaseLink>> additionalDirectedLinkClasses;
    private Collection<Class<? extends BaseLink>> additionalUndirectedLinkClasses;
    Map<String, Class<? extends BaseLink>> linkTypesMap = new ConcurrentHashMap<String, Class<? extends BaseLink>>();

    public Class<?> getLinkTypeClass(String linkType) {
        String standardizedLinkType = linkType.toLowerCase();
        return this.linkTypesMap.get(standardizedLinkType);
    }

    public LinkFactory(Class<? extends BaseLink> linkClass) {
        this(linkClass, linkClass);
    }

    public LinkFactory(Class<? extends BaseLink> dirLinkClass, Class<? extends BaseLink> undirLinkClass) {
        this(dirLinkClass, undirLinkClass, ReLogoImplementingClassesFinder.find(BaseLink.class));
    }

    public LinkFactory(Class<? extends BaseLink> linkClass, Collection<Class<? extends BaseLink>> additionalLinkList) {
        this(linkClass, linkClass, additionalLinkList);
    }

    public LinkFactory(Class<? extends BaseLink> dirLinkClass, Class<? extends BaseLink> undirLinkClass, Collection<Class<? extends BaseLink>> additionalLinkClasses) {
        if (!BaseLink.class.isAssignableFrom(dirLinkClass)) {
            throw new RuntimeException("Argument " + dirLinkClass + " to LinkFactory's constructor needs to extend BaseLink.");
        }
        if (!BaseLink.class.isAssignableFrom(undirLinkClass)) {
            throw new RuntimeException("Argument " + undirLinkClass + " to LinkFactory's constructor needs to extend BaseLink.");
        }
        for (Class<? extends BaseLink> clazz : additionalLinkClasses) {
            if (BaseLink.class.isAssignableFrom(clazz)) continue;
            throw new RuntimeException("Argument " + clazz + " to LinkFactory's constructor needs to extend BaseLink.");
        }
        this.defaultDirectedLinkClass = dirLinkClass;
        String singularName = dirLinkClass.getSimpleName();
        String pluralName = dirLinkClass.isAnnotationPresent(Plural.class) ? dirLinkClass.getAnnotation(Plural.class).value() : String.valueOf(singularName) + "s";
        this.linkTypesMap.put(singularName.toLowerCase(), dirLinkClass);
        this.linkTypesMap.put(pluralName.toLowerCase(), dirLinkClass);
        this.defaultUndirectedLinkClass = undirLinkClass;
        if (!dirLinkClass.equals(undirLinkClass)) {
            singularName = undirLinkClass.getSimpleName();
            pluralName = undirLinkClass.isAnnotationPresent(Plural.class) ? undirLinkClass.getAnnotation(Plural.class).value() : String.valueOf(singularName) + "s";
            this.linkTypesMap.put(singularName.toLowerCase(), undirLinkClass);
            this.linkTypesMap.put(pluralName.toLowerCase(), undirLinkClass);
        }
        this.additionalDirectedLinkClasses = new ArrayList<Class<? extends BaseLink>>();
        this.additionalUndirectedLinkClasses = new ArrayList<Class<? extends BaseLink>>();
        for (Class<? extends BaseLink> clazz : additionalLinkClasses) {
            if (clazz.isAnnotationPresent(Directed.class)) {
                this.additionalDirectedLinkClasses.add(clazz);
            } else if (clazz.isAnnotationPresent(Undirected.class)) {
                this.additionalUndirectedLinkClasses.add(clazz);
            } else {
                this.additionalDirectedLinkClasses.add(clazz);
            }
            singularName = clazz.getSimpleName();
            pluralName = clazz.isAnnotationPresent(Plural.class) ? clazz.getAnnotation(Plural.class).value() : String.valueOf(singularName) + "s";
            this.linkTypesMap.put(singularName.toLowerCase(), clazz);
            this.linkTypesMap.put(pluralName.toLowerCase(), clazz);
        }
    }

    public Link createLink(Class<? extends BaseLink> linkClass, Object source, Object target, boolean directed) {
        return this.createLink(linkClass, source, target, directed, 1.0);
    }

    public Link createLink(Class<? extends BaseLink> linkClass, Object source, Object target, boolean directed, double weight) {
        if (this.observer == null) {
            throw new RuntimeException("The LinkFactory init method needs to be called before instatiating Links.");
        }
        if (linkClass != this.defaultDirectedLinkClass && linkClass != this.defaultUndirectedLinkClass && !this.additionalDirectedLinkClasses.contains(linkClass) && !this.additionalUndirectedLinkClasses.contains(linkClass)) {
            throw new RuntimeException("First argument " + linkClass + " to LinkFactory.createLink was not used in the LinkFactory constructor.");
        }
        BaseLink link = null;
        try {
            link = linkClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        link.setBaseLinkProperties(this.observer, this, source, target, directed, weight);
        return link;
    }

    public void init(Observer observer) {
        this.observer = observer;
        Context context = this.observer.getContext();
        NetworkBuilder nbD = new NetworkBuilder("DirectedLinks", context, true);
        nbD.setEdgeCreator((EdgeCreator)new ReLogoEdgeCreator(this, this.defaultDirectedLinkClass)).buildNetwork().addProjectionListener((ProjectionListener)observer);
        nbD = new NetworkBuilder("UndirectedLinks", context, false);
        nbD.setEdgeCreator((EdgeCreator)new ReLogoEdgeCreator(this, this.defaultUndirectedLinkClass)).buildNetwork().addProjectionListener((ProjectionListener)observer);
        nbD = new NetworkBuilder("Tracking Network", context, false);
        nbD.setEdgeCreator(new TrackingEdgeCreator()).buildNetwork();
        for (Class<? extends BaseLink> clazz : this.additionalDirectedLinkClasses) {
            this.createNetwork(observer, clazz, true);
        }
        for (Class<? extends BaseLink> clazz : this.additionalUndirectedLinkClasses) {
            this.createNetwork(observer, clazz, false);
        }
    }

    private void createNetwork(Observer observer, Class<? extends BaseLink> linkClass, boolean directed) {
        String networkName = linkClass.getSimpleName();
        NetworkBuilder nbD = new NetworkBuilder(networkName, observer.getContext(), directed);
        nbD.setEdgeCreator((EdgeCreator)new ReLogoEdgeCreator(this, linkClass)).buildNetwork().addProjectionListener((ProjectionListener)observer);
    }
}

