/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import groovy.lang.ExpandoMetaClass;
import groovy.util.ObservableMap;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.relogo.FileInfo;
import repast.simphony.ui.RSApplication;
import repast.simphony.visualization.IDisplay;
import simphony.util.messages.MessageCenter;

public class ReLogoModel
implements RunListener {
    public static final Color DEFAULT_TURTLE_COLOR = Color.white;
    public static final Double MONITOR_PRIORITY = -100.0;
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(ReLogoModel.class);
    private static ReLogoModel uniqueInstance = new ReLogoModel();
    private boolean eMCEnabledGlobally = false;
    Map<String, IAction> actions = new ConcurrentHashMap<String, IAction>();
    private boolean paused = true;
    private int activeButtons;
    private double ticks = 0.0;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Map monitorsMap = new ObservableMap(new ConcurrentHashMap());
    Map modelParams = new ObservableMap(new ConcurrentHashMap());
    private File currentDirectory;
    private FileInfo currentFileInfo;
    private ArrayList<FileInfo> fileInfoList = new ArrayList();
    private long lastTimer;
    private IDisplay defaultDisplay;

    private ReLogoModel() {
    }

    public static ReLogoModel getInstance() {
        return uniqueInstance;
    }

    private boolean isEMCEnabledGlobally() {
        return this.eMCEnabledGlobally;
    }

    private void setEMCEnabledGlobally(boolean eMcEnabledGlobally) {
        this.eMCEnabledGlobally = eMcEnabledGlobally;
    }

    public void checkEMCEnabledGlobally() {
        if (!this.isEMCEnabledGlobally()) {
            ExpandoMetaClass.enableGlobally();
            this.setEMCEnabledGlobally(true);
        }
    }

    public Map getActions() {
        return this.actions;
    }

    public IAction getAction(String actionName) {
        return this.actions.get(actionName);
    }

    public void addAction(String actionName, IAction action) {
        this.actions.put(actionName, action);
    }

    public IAction removeAction(String actionName) {
        return this.actions.remove(actionName);
    }

    public int getActiveButtons() {
        return this.activeButtons;
    }

    public void setActiveButtons(int activeButtons) {
        this.activeButtons = activeButtons;
    }

    public void incrementActiveButtons() {
        ++this.activeButtons;
    }

    public void decrementActiveButtons() {
        --this.activeButtons;
    }

    public boolean isPaused() {
        return this.paused;
    }

    private void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setTicks(double ticks) {
        this.ticks = ticks;
        this.pcs.firePropertyChange("ticks", this.ticks, this.ticks);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public double getTicks() {
        return this.ticks;
    }

    public Object getMonitor(String paramName) {
        return this.monitorsMap.get(paramName);
    }

    public void setMonitor(String paramName, Object value) {
        if (value != null) {
            this.monitorsMap.put(paramName, value);
        }
    }

    public Map getModelParams() {
        return this.modelParams;
    }

    public Object getModelParam(String paramName) {
        return this.modelParams.get(paramName);
    }

    public void setModelParam(String paramName, Object value) {
        if (value != null) {
            this.modelParams.put(paramName, value);
        }
    }

    public long getLastTimer() {
        return this.lastTimer;
    }

    public void setLastTimer(long lastTimer) {
        this.lastTimer = lastTimer;
    }

    public void resetInstance() {
        this.currentDirectory = null;
        this.currentFileInfo = null;
        this.fileInfoList = new ArrayList();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public FileInfo getCurrentFileInfo() {
        return this.currentFileInfo;
    }

    public ArrayList<FileInfo> getFileInfoList() {
        return this.fileInfoList;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setCurrentFileInfo(FileInfo currentFileInfo) {
        this.currentFileInfo = currentFileInfo;
    }

    public void setFileInfoList(ArrayList<FileInfo> fileInfoList) {
        this.fileInfoList = fileInfoList;
    }

    public IDisplay getDefaultDisplay() {
        return this.defaultDisplay;
    }

    public void setDefaultDisplay(IDisplay defaultDisplay) {
        this.defaultDisplay = defaultDisplay;
    }

    public void updateDisplay() {
        if (this.defaultDisplay != null && this.isPaused()) {
            this.defaultDisplay.update();
            this.defaultDisplay.render();
        }
    }

    public void stopped() {
        RSApplication rsApp;
        this.setPaused(true);
        this.setTicks(0.0);
        if (!RunEnvironment.getInstance().isBatch() && (rsApp = RSApplication.getRSApplicationInstance()) != null && rsApp.hasCustomUserPanelDefined()) {
            rsApp.removeCustomUserPanel();
        }
    }

    public void paused() {
        this.setPaused(true);
    }

    public void started() {
        this.setPaused(false);
    }

    public void restarted() {
        this.setPaused(false);
    }
}

