/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.relogo;

import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import repast.simphony.relogo.BaseObserver;
import repast.simphony.relogo.ClassAGroovy;
import repast.simphony.relogo.ClassBGroovy;
import repast.simphony.relogo.ClassC;
import repast.simphony.relogo.ClassD;
import repast.simphony.relogo.ClassEGroovy;

public class BaseObserverTests {
    BaseObserver obs;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.obs = new BaseObserver();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void simpleGroovyClass() {
        List<String> fieldsAndProps = this.obs.getPublicFieldsAndProperties(ClassAGroovy.class);
        Assert.assertEquals((long)3L, (long)fieldsAndProps.size());
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop2"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("field1"));
        Assert.assertFalse((boolean)fieldsAndProps.contains("field2"));
    }

    @Test
    public void inheritedGroovyClass() {
        List<String> fieldsAndProps = this.obs.getPublicFieldsAndProperties(ClassBGroovy.class);
        Assert.assertEquals((long)4L, (long)fieldsAndProps.size());
        Assert.assertTrue((boolean)fieldsAndProps.contains("bprop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop2"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("field1"));
    }

    @Test
    public void simpleJavaClass() {
        List<String> fieldsAndProps = this.obs.getPublicFieldsAndProperties(ClassC.class);
        Assert.assertEquals((long)2L, (long)fieldsAndProps.size());
        Assert.assertTrue((boolean)fieldsAndProps.contains("cprop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("cfield1"));
    }

    @Test
    public void inheritedJavaFromGroovyClass() {
        List<String> fieldsAndProps = this.obs.getPublicFieldsAndProperties(ClassD.class);
        Assert.assertEquals((long)5L, (long)fieldsAndProps.size());
        Assert.assertTrue((boolean)fieldsAndProps.contains("bprop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("prop2"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("field1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("dfield1"));
    }

    @Test
    public void inheritedGroovyFromJavaClass() {
        List<String> fieldsAndProps = this.obs.getPublicFieldsAndProperties(ClassEGroovy.class);
        Assert.assertEquals((long)3L, (long)fieldsAndProps.size());
        Assert.assertTrue((boolean)fieldsAndProps.contains("cprop1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("cfield1"));
        Assert.assertTrue((boolean)fieldsAndProps.contains("eprop1"));
    }
}

