/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.io.StringReader;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junitx.util.PrivateAccessor;
import org.jmock.MockObjectTestCase;
import repast.simphony.util.Scanner;

public class ScannerTest
extends MockObjectTestCase {
    private Scanner scanner;

    protected void setUp() throws Exception {
        this.scanner = new Scanner("blah\nfoo:bar");
    }

    public void testScannerString() throws NoSuchFieldException, IOException {
        this.scanner = new Scanner("blah");
        StringReader reader = (StringReader)PrivateAccessor.getField((Object)this.scanner, (String)"source");
        char[] charBuf = new char[1];
        reader.read(charBuf);
        ScannerTest.assertEquals((char)'b', (char)charBuf[0]);
        reader.read(charBuf);
        ScannerTest.assertEquals((char)'l', (char)charBuf[0]);
        reader.read(charBuf);
        ScannerTest.assertEquals((char)'a', (char)charBuf[0]);
        reader.read(charBuf);
        ScannerTest.assertEquals((char)'h', (char)charBuf[0]);
        ScannerTest.assertEquals((int)-1, (int)reader.read());
    }

    public void testScannerReadable() throws NoSuchFieldException {
        Readable readable = (Readable)this.mock(Readable.class).proxy();
        this.scanner = new Scanner(readable);
        ScannerTest.assertSame((Object)readable, (Object)PrivateAccessor.getField((Object)this.scanner, (String)"source"));
    }

    public void testScannerReadableByteChannel() {
    }

    public void testScannerReadableByteChannelString() {
    }

    public void testHasNext() {
        this.scanner.useDelimiter("\n");
        ScannerTest.assertTrue((boolean)this.scanner.hasNext());
        this.scanner.next();
        ScannerTest.assertTrue((boolean)this.scanner.hasNext());
        this.scanner.next();
        ScannerTest.assertFalse((boolean)this.scanner.hasNext());
    }

    public void testNext() {
        this.scanner.useDelimiter("\n");
        ScannerTest.assertEquals((String)"blah", (String)this.scanner.next());
        ScannerTest.assertEquals((String)"foo:bar", (String)this.scanner.next());
        try {
            this.scanner.next();
            ScannerTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetNextDelimited() {
        this.scanner.useDelimiter("\n");
        ScannerTest.assertEquals((String)"blah", (String)this.scanner.getNextDelimited());
        ScannerTest.assertEquals((String)"foo:bar", (String)this.scanner.getNextDelimited());
    }

    public void testMixedGets() {
        this.scanner.useDelimiter("\n");
        ScannerTest.assertEquals((String)"b", (String)this.scanner.getNextPattern("."));
        ScannerTest.assertEquals((String)"lah", (String)this.scanner.getNextDelimited());
        ScannerTest.assertEquals((String)"fo", (String)this.scanner.getNextLength(2));
        ScannerTest.assertEquals((String)"o:", (String)this.scanner.getNextPattern(".*:"));
        ScannerTest.assertEquals((String)"bar", (String)this.scanner.getNextDelimited());
    }

    public void testGetNextPattern() {
        ScannerTest.assertEquals((String)"blah", (String)this.scanner.getNextPattern("blah"));
        ScannerTest.assertEquals((String)"\n", (String)this.scanner.getNextPattern("."));
        ScannerTest.assertEquals((String)"foo:bar", (String)this.scanner.getNextPattern(".+"));
    }

    public void testGetNextLength() {
        ScannerTest.assertEquals((String)"blah", (String)this.scanner.getNextLength(4));
        ScannerTest.assertEquals((String)"\nfoo:bar", (String)this.scanner.getNextLength("\nfoo:bar".length()));
        try {
            this.scanner.getNextLength(1);
            ScannerTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetNextLengthOverflow() {
        ScannerTest.assertEquals((String)"blah", (String)this.scanner.getNextLength(4));
        try {
            ScannerTest.assertEquals((String)"\nfoo:bar", (String)this.scanner.getNextLength("\nfoo:bar".length() + 1));
            ScannerTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testUseDelimiter() throws NoSuchFieldException {
        String delimiter = "asdfasdfasdf";
        this.scanner.useDelimiter(delimiter);
        ScannerTest.assertEquals((String)delimiter, (String)((Pattern)PrivateAccessor.getField((Object)this.scanner, (String)"delimPattern")).pattern());
        ScannerTest.assertEquals((String)delimiter, (String)((Matcher)PrivateAccessor.getField((Object)this.scanner, (String)"delimMatcher")).pattern().pattern());
    }

    public void testDelimiter() throws NoSuchFieldException {
        Pattern delimiter = Pattern.compile("asdfasdfasdf");
        PrivateAccessor.setField((Object)this.scanner, (String)"delimPattern", (Object)delimiter);
        ScannerTest.assertEquals((Object)delimiter, (Object)this.scanner.delimiter());
    }

    public void testRemove() {
        try {
            this.scanner.remove();
            ScannerTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

