/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.Stack;

public class RandomAccessWriter
extends PrintWriter {
    private FileChannel fileChannel;
    private Stack<Long> markStack;

    public RandomAccessWriter(File file) throws FileNotFoundException {
        super(file);
        this.init(null, file);
    }

    public RandomAccessWriter(String fileName) throws FileNotFoundException {
        super(fileName);
        this.init(fileName, null);
    }

    private void init(String fileName, File file) throws FileNotFoundException {
        this.markStack = new Stack();
        this.captureFileChannel(fileName, file);
    }

    private void captureFileChannel(String fileName, File file) throws FileNotFoundException {
        FileOutputStream outStream = fileName != null ? new FileOutputStream(fileName) : new FileOutputStream(file);
        this.out = new BufferedWriter(new OutputStreamWriter(outStream));
        this.fileChannel = outStream.getChannel();
    }

    private long getFileOffsetInternal() throws IOException {
        super.flush();
        return this.fileChannel.position();
    }

    public long getTrueOffset() throws IOException {
        long fileOffset = this.getFileOffsetInternal();
        if (fileOffset <= 0L) {
            return fileOffset;
        }
        return fileOffset;
    }

    public void mark() throws IOException {
        this.markStack.push(this.getTrueOffset());
    }

    public Long popMark() {
        if (!this.markStack.isEmpty()) {
            return this.markStack.pop();
        }
        return null;
    }

    public void reset() throws IOException {
        super.flush();
        this.position(this.markStack.peek());
    }

    public void position(long position) throws IOException {
        this.fileChannel.position(position);
    }

    public FileChannel truncateToPosition() throws IOException {
        return this.truncate(this.getTrueOffset());
    }

    public FileChannel truncate(long size) throws IOException {
        super.flush();
        return this.fileChannel.truncate(size);
    }

    @Override
    public void close() {
        try {
            super.close();
            this.fileChannel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

