/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import repast.simphony.util.SystemConstants;

public enum NewLinePatternConverter {
    NONE("none"){

        @Override
        public String convert(String string) {
            return string;
        }
    }
    ,
    SYSTEM("system"){

        @Override
        public String convert(String string) {
            if (SystemConstants.LINE_SEPARATOR.equals("\r\n")) {
                return WINDOWS.convert(string);
            }
            if (SystemConstants.LINE_SEPARATOR.equals("\n")) {
                return UNIX.convert(string);
            }
            return string;
        }
    }
    ,
    WINDOWS("windows"){

        @Override
        public String convert(String string) {
            return string.replaceAll("\\\\n", "\\\\r\\\\n");
        }
    }
    ,
    UNIX("unix"){

        @Override
        public String convert(String string) {
            return string;
        }
    };

    private final String type;

    private NewLinePatternConverter(String descriptor) {
        this.type = descriptor;
    }

    public static NewLinePatternConverter getNewLineConverter(String handleType) {
        NewLinePatternConverter[] newLinePatternConverterArray = NewLinePatternConverter.values();
        int n = newLinePatternConverterArray.length;
        int n2 = 0;
        while (n2 < n) {
            NewLinePatternConverter handler = newLinePatternConverterArray[n2];
            if (handler.type.equalsIgnoreCase(handleType)) {
                return handler;
            }
            ++n2;
        }
        return NONE;
    }

    public String getType() {
        return this.type;
    }

    public abstract String convert(String var1);

    /* synthetic */ NewLinePatternConverter(String string, int n, String string2, NewLinePatternConverter newLinePatternConverter) {
        this(string2);
    }
}

