/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.security.InvalidParameterException;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import repast.simphony.integration.DataFileElements;
import repast.simphony.integration.FileDef;
import simphony.util.messages.MessageCenter;

public class JXPathUtils {
    public static final String XPATH_FILE_DEF_CORRECT = DataFileElements.FILE_DEF.getTag().replaceFirst("F", "f");
    public static final String XPATH_FILE_DEF_WRONG = DataFileElements.FILE_DEF.getTag();
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(JXPathUtils.class);

    public static JXPathContext createContext(Object rootObj, boolean lenient) {
        JXPathContext context = JXPathContext.newContext((Object)rootObj);
        context.setLenient(lenient);
        return context;
    }

    public static JXPathContext createRootContext(Object obj, boolean lenient) {
        return JXPathUtils.createContext(new FileDef(obj), lenient);
    }

    public static JXPathContext getContext(JXPathContext rootContext, JXPathContext curContext, String path) {
        if (!path.startsWith("/")) {
            if (curContext == null) {
                return rootContext;
            }
            return curContext;
        }
        if (rootContext != null) {
            return rootContext;
        }
        return curContext;
    }

    public static String fixPath(String path) {
        return path.replace(XPATH_FILE_DEF_WRONG, XPATH_FILE_DEF_CORRECT);
    }

    public static Object getXPathNode(JXPathContext rootContext, JXPathContext curContext, String path) {
        if (rootContext == null && curContext == null) {
            InvalidParameterException ex = new InvalidParameterException("Must pass in a non-null context to evaluate, rootContext and curContext cannot both be null");
            msgCenter.error((Object)"rootContext and curContext cannot both be null", (Throwable)ex, new Object[0]);
            throw ex;
        }
        JXPathContext contextToUse = JXPathUtils.getContext(rootContext, curContext, path);
        path = JXPathUtils.fixPath(path);
        return contextToUse.getValue(path);
    }

    public static List<?> getXPathNodes(JXPathContext rootContext, JXPathContext curContext, String path) {
        if (rootContext == null && curContext == null) {
            InvalidParameterException ex = new InvalidParameterException("Must pass in a non-null context to evaluate, rootContext and curContext cannot both be null");
            msgCenter.error((Object)"rootContext and curContext cannot both be null", (Throwable)ex, new Object[0]);
            throw ex;
        }
        JXPathContext contextToUse = JXPathUtils.getContext(rootContext, curContext, path);
        path = JXPathUtils.fixPath(path);
        return contextToUse.selectNodes(path);
    }
}

