/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.util.ArrayList;
import junit.framework.TestCase;
import junitx.util.PrivateAccessor;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import repast.simphony.integration.DataContent;
import repast.simphony.integration.JDOMQueryer;

public class JDOMQueryerTest
extends TestCase {
    private Element rootElement;
    private Document rootDocument;
    private JDOMQueryer queryer;
    private Element subElement;
    private String subElementData;

    protected void setUp() throws Exception {
        this.rootElement = new Element("root");
        this.rootDocument = new Document(this.rootElement);
        this.queryer = new JDOMQueryer(this.rootDocument);
        this.subElement = new Element("sub");
        this.subElementData = "subElementData";
        this.subElement.addContent((Content)new DataContent(this.subElementData));
        this.rootElement.addContent((Content)this.subElement);
    }

    public void testJDOMQueryer() throws NoSuchFieldException {
        JDOMQueryerTest.assertEquals((Object)PrivateAccessor.getField((Object)this.queryer, (String)"document"), (Object)this.rootDocument);
    }

    public void testSelectNodeString() {
        JDOMQueryerTest.assertEquals((Object)this.subElement, (Object)this.queryer.selectNode("/root/sub"));
        JDOMQueryerTest.assertEquals((Object)this.rootElement, (Object)this.queryer.selectNode("/root"));
        JDOMQueryerTest.assertEquals((Object)this.rootDocument, (Object)this.queryer.selectNode("/"));
        JDOMQueryerTest.assertNull((Object)this.queryer.selectNode("asdf/asdf/asdf/"));
    }

    public void testSelectNodeObjectString() {
        JDOMQueryerTest.assertEquals((Object)this.subElement, (Object)this.queryer.selectNode(this.rootElement, "/root/sub"));
        JDOMQueryerTest.assertEquals((Object)this.subElement, (Object)this.queryer.selectNode(this.subElement, "/root/sub"));
        JDOMQueryerTest.assertEquals((Object)this.subElement, (Object)this.queryer.selectNode(this.subElement, "."));
        JDOMQueryerTest.assertEquals((Object)this.subElement, (Object)this.queryer.selectNode(this.rootElement, "sub"));
        JDOMQueryerTest.assertNull((Object)this.queryer.selectNode(this.rootDocument, "sub"));
        JDOMQueryerTest.assertNull(this.queryer.selectNodes("blah", "sub"));
        JDOMQueryerTest.assertNull((Object)this.queryer.selectNode(this.rootDocument, "/[]"));
    }

    public void testSelectNodesString() {
        ArrayList<Element> values = new ArrayList<Element>();
        values.add(this.subElement);
        JDOMQueryerTest.assertEquals(values, this.queryer.selectNodes("//sub"));
        values = new ArrayList();
        values.add(this.rootElement);
        JDOMQueryerTest.assertEquals(values, this.queryer.selectNodes("/root"));
    }

    public void testSelectNodesObjectString() {
        ArrayList<Element> values = new ArrayList<Element>();
        values.add(this.subElement);
        JDOMQueryerTest.assertEquals(values, this.queryer.selectNodes(this.rootElement, "//sub"));
        JDOMQueryerTest.assertEquals(values, this.queryer.selectNodes(this.rootElement, "sub"));
        values = new ArrayList();
        values.add(this.rootElement);
        JDOMQueryerTest.assertEquals(values, this.queryer.selectNodes(this.rootElement, "/root"));
    }

    public void testGetRoot() {
        JDOMQueryerTest.assertEquals((Object)this.rootElement, (Object)this.queryer.getRoot());
    }

    public void testGetValue() {
        JDOMQueryerTest.assertEquals((Object)this.subElementData, (Object)this.queryer.getValue(this.subElement));
    }

    public void testGetValue2() {
        JDOMQueryerTest.assertEquals((Object)this.subElementData, (Object)this.queryer.getValue(this.queryer.selectNode("/root/sub")));
    }
}

