/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import repast.simphony.integration.JDOMXPathUtils;
import repast.simphony.integration.Queryable;
import simphony.util.messages.MessageCenter;

public class JDOMQueryer
implements Queryable {
    private static final MessageCenter msgCenter = MessageCenter.getMessageCenter(JDOMQueryer.class);
    private Document document;

    public JDOMQueryer(Document document) {
        this.document = document;
    }

    @Override
    public Object selectNode(String path) {
        return this.selectNode(this.document.getRootElement(), path);
    }

    @Override
    public Object selectNode(Object curContext, String path) {
        if (!(curContext instanceof Element)) {
            msgCenter.warn((Object)"Received a context that was not an element. The context must be an element.  Returning null.", new Object[0]);
            return null;
        }
        try {
            return JDOMXPathUtils.evalXPath(path, (Element)curContext);
        }
        catch (JDOMException jDOMException) {
            return null;
        }
    }

    @Override
    public List<?> selectNodes(String path) {
        return this.selectNodes(this.document.getRootElement(), path);
    }

    @Override
    public List<?> selectNodes(Object curContext, String path) {
        if (!(curContext instanceof Element)) {
            msgCenter.warn((Object)"Received a context that was not an element. The context must be an element.  Returning null.", new Object[0]);
            return null;
        }
        try {
            return JDOMXPathUtils.evalXPaths(path, (Element)curContext);
        }
        catch (JDOMException jDOMException) {
            return null;
        }
    }

    @Override
    public Object getRoot() {
        return this.document.getRootElement();
    }

    @Override
    public Object getValue(Object o) {
        return JDOMXPathUtils.getValue(o);
    }
}

