/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import repast.simphony.integration.DataContent;
import repast.simphony.integration.DataFileElements;
import repast.simphony.integration.DataFileUtils;
import repast.simphony.integration.JDOMQueryer;
import repast.simphony.integration.OutputBuilder;

public class JDOMBuilder
implements OutputBuilder<Element, Document> {
    private Document document;
    private Element root;
    private Element curElement;
    private JDOMQueryer queryer;

    @Override
    public Element createAndGoInto(String name) {
        Element parentElement = (Element)DataFileUtils.findExplicitTargetParent(this, name);
        name = DataFileUtils.getName(name);
        Element element = new Element(name);
        if (parentElement == null) {
            parentElement = this.curElement;
        }
        parentElement.addContent((Content)element);
        this.curElement = element;
        return element;
    }

    @Override
    public void goUp() {
        this.curElement = this.curElement.getParentElement();
    }

    @Override
    public void goRoot() {
        this.curElement = this.root;
    }

    @Override
    public Element writeValue(String name, Object value) {
        Element parentElement = (Element)DataFileUtils.findExplicitTargetParent(this, name);
        name = DataFileUtils.getName(name);
        if (parentElement == null) {
            parentElement = this.curElement;
        }
        Element element = new Element(name);
        element.addContent((Content)new DataContent(value));
        parentElement.addContent((Content)element);
        return element;
    }

    @Override
    public Document getWrittenObject() {
        return this.document;
    }

    @Override
    public void detach() {
        Element parent = this.curElement.getParentElement();
        this.curElement.detach();
        this.curElement = parent;
    }

    @Override
    public void detach(Iterable<Element> objsToDetach) {
        for (Element element : objsToDetach) {
            element.detach();
        }
    }

    @Override
    public void initialize() {
        this.document = new Document(new Element(DataFileElements.FILE_DEF.getTag()));
        this.root = this.document.getRootElement();
        this.queryer = new JDOMQueryer(this.document);
        this.goRoot();
    }

    @Override
    public Object selectNode(String path) {
        return this.selectNode(this.curElement, path);
    }

    @Override
    public Object selectNode(Object curContext, String path) {
        return this.queryer.selectNode(curContext, path);
    }

    @Override
    public List<?> selectNodes(String path) {
        return this.selectNodes(this.curElement, path);
    }

    @Override
    public List<?> selectNodes(Object curContext, String path) {
        return this.queryer.selectNodes(curContext, path);
    }

    @Override
    public Object getRoot() {
        return this.queryer.getRoot();
    }

    @Override
    public Object getValue(Object o) {
        return this.queryer.getValue(o);
    }
}

