/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import repast.simphony.integration.CustomExecute;
import repast.simphony.integration.LegacyExecutor;
import simphony.util.messages.MessageCenter;

public class DefaultLegacyExecutor
implements LegacyExecutor {
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(DefaultLegacyExecutor.class);
    private CommandLine commandLine;
    private Map environment;
    private Process spawnedProcess;
    private boolean readExitSig;

    public DefaultLegacyExecutor(String executable, String[] args, Map environment) {
        this.commandLine = new CommandLine(executable);
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                this.commandLine.addArgument(arg);
                ++n2;
            }
        }
        this.environment = environment;
    }

    @Override
    public int execute() throws IOException {
        DefaultExecutor exec = new DefaultExecutor();
        if (this.environment != null) {
            return exec.execute(this.commandLine, this.environment);
        }
        return exec.execute(this.commandLine);
    }

    @Override
    public void spawn() throws IOException {
        if (this.spawnedProcess != null && !this.readExitSig) {
            LOG.debug((Object)"Spawning a new process without having read the exit code of the previous process", new Object[0]);
        }
        this.readExitSig = false;
        CustomExecute exec = new CustomExecute();
        exec.setCommandLine(this.commandLine);
        if (this.environment != null) {
            exec.setEnvironment(this.environment);
        }
        this.spawnedProcess = exec.spawnAndReturnProcess();
    }

    public int waitForSpawn() throws InterruptedException {
        this.readExitSig = true;
        return this.spawnedProcess.waitFor();
    }

    public int exitValue() {
        this.readExitSig = true;
        return this.spawnedProcess.exitValue();
    }

    public static void main(String[] args) {
        String command = "C:\\Program Files (x86)\\Microsoft Office\\Office14\\EXCEL.EXE";
        String[] commandargs = new String[]{"/e"};
        DefaultLegacyExecutor exec = new DefaultLegacyExecutor(command, commandargs, null);
        try {
            exec.spawn();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

