/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import repast.simphony.integration.DefaultLegacyExecutor;
import repast.simphony.integration.ExternalProgramRunner;
import repast.simphony.integration.IntegrationSource;
import repast.simphony.integration.LegacyExecutor;
import repast.simphony.integration.Queryable;
import simphony.util.messages.MessageCenter;

public class DefaultExtProgRunner
implements ExternalProgramRunner {
    private MessageCenter msgCenter = MessageCenter.getMessageCenter(DefaultExtProgRunner.class);
    private static final long serialVersionUID = 7673974590328212428L;
    private LegacyExecutor executor;
    private ArrayList<IntegrationSource> integrationSources = new ArrayList();

    public DefaultExtProgRunner() {
        this.executor = new DefaultLegacyExecutor("", null, null);
    }

    @Override
    public void write() throws Exception {
        for (IntegrationSource source : this.integrationSources) {
            source.write();
        }
    }

    public void execute() {
        try {
            this.executor.execute();
        }
        catch (IOException e) {
            this.msgCenter.warn((Object)"Error executing external program. Continuing.", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void read() throws Exception {
        for (IntegrationSource source : this.integrationSources) {
            source.read();
        }
    }

    @Override
    public void addSource(IntegrationSource source) {
        this.integrationSources.add(source);
    }

    @Override
    public boolean removeSource(IntegrationSource source) {
        return this.integrationSources.remove(source);
    }

    @Override
    public List<IntegrationSource> getSources() {
        return this.integrationSources;
    }

    @Override
    public void setWrittenObject(Queryable queryable) {
        for (IntegrationSource source : this.integrationSources) {
            source.setWrittenObject(queryable);
        }
    }

    @Override
    public LegacyExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(LegacyExecutor executor) {
        this.executor = executor;
    }
}

