/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

public enum DataTypeHandler {
    STRING("string"){

        @Override
        public String convert(String string) {
            return string;
        }
    }
    ,
    INT("int"){

        @Override
        public Integer convert(String string) {
            if ((string = string.trim()).endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return Integer.valueOf(string.trim());
        }
    }
    ,
    DOUBLE("double"){

        @Override
        public Double convert(String string) {
            return Double.valueOf(string);
        }
    };

    private String typeName;

    private DataTypeHandler(String typeName) {
        this.typeName = typeName;
    }

    public static DataTypeHandler getDataType(String typeName) {
        DataTypeHandler[] dataTypeHandlerArray = DataTypeHandler.values();
        int n = dataTypeHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataTypeHandler handler = dataTypeHandlerArray[n2];
            if (handler.typeName.equalsIgnoreCase(typeName)) {
                return handler;
            }
            ++n2;
        }
        return null;
    }

    public abstract Object convert(String var1);

    public String getTypeName() {
        return this.typeName;
    }

    /* synthetic */ DataTypeHandler(String string, int n, String string2, DataTypeHandler dataTypeHandler) {
        this(string2);
    }
}

