/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import repast.simphony.integration.BeanQueryer;
import repast.simphony.integration.DataFileElementWriter;
import repast.simphony.integration.DataFileUtils;
import repast.simphony.integration.DataTypeHandler;
import repast.simphony.integration.EscapeConverter;
import repast.simphony.integration.Queryable;
import repast.simphony.integration.RandomAccessWriter;
import repast.simphony.integration.Writer;
import simphony.util.messages.MessageCenter;

public class DataFileWriter
implements Writer,
Queryable {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(DataFileWriter.class);
    private Document descriptorDocument;
    private String descriptorFileName;
    private Queryable dataSource;
    private RandomAccessWriter writer;
    private String destFileName;
    private EscapeConverter newLineConverter;

    public DataFileWriter() {
        this(null);
    }

    public DataFileWriter(Object source) {
        this(new BeanQueryer(source));
    }

    public DataFileWriter(Queryable dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void write() throws JDOMException, IOException {
        this.intializeForWrite();
        this.handleElement(this.dataSource.getRoot(), this.descriptorDocument.getRootElement());
        this.handleChildren(this.dataSource.getRoot(), this.descriptorDocument.getRootElement());
        this.shutdownWrite();
    }

    private void loadDescriptorDoc() throws JDOMException, IOException {
        this.descriptorDocument = DataFileUtils.loadDescriptor(this.descriptorFileName);
    }

    private void handleElement(Object dataParent, Element dataDescriptor) throws IOException {
        DataFileElementWriter.getElementHandler(dataDescriptor).handle(this, dataParent, dataDescriptor);
    }

    private void handleChildren(Object dataParent, Element dataDescriptor) throws IOException {
        List childNodes = dataDescriptor.getChildren();
        int i = 0;
        while (i < childNodes.size()) {
            try {
                this.handleElement(dataParent, (Element)childNodes.get(i));
            }
            catch (RuntimeException ex) {
                msgCenter.error((Object)("Error working on node" + childNodes.get(i)), (Throwable)ex, new Object[0]);
                throw ex;
            }
            ++i;
        }
    }

    private void intializeForWrite() throws JDOMException, IOException {
        this.writer = new RandomAccessWriter(this.destFileName);
        this.loadDescriptorDoc();
    }

    private void shutdownWrite() {
        this.writer.close();
    }

    public void setNewLineConverter(EscapeConverter newLineConverter) {
        this.newLineConverter = newLineConverter;
    }

    public EscapeConverter getNewLineConverter() {
        return this.newLineConverter;
    }

    public void writeValueDelimiter(Object data, String delimiter) {
        this.writer.write(this.convertNewLines(data.toString()));
        this.writer.write(this.convertNewLines(delimiter));
    }

    private String convertNewLines(String string) {
        return this.newLineConverter.convert(string);
    }

    public void writeValuePattern(Object data, String type, String pattern) {
        Formatter formatter = new Formatter();
        formatter.format(pattern, DataTypeHandler.getDataType(type).convert(data.toString()));
        this.writer.write(this.convertNewLines(formatter.toString()));
    }

    public void setDestFileName(String fileName) {
        this.destFileName = fileName;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public void setDescriptorFileName(String descriptorFileName) {
        this.descriptorFileName = descriptorFileName;
    }

    public String getDescriptorFileName() {
        return this.descriptorFileName;
    }

    public void mark() throws IOException {
        this.writer.mark();
    }

    public void popMark() {
        this.writer.popMark();
    }

    public void reset() throws IOException {
        this.writer.reset();
    }

    @Override
    public Object selectNode(String path) {
        return this.dataSource.selectNode(path);
    }

    @Override
    public Object selectNode(Object curContext, String path) {
        return this.dataSource.selectNode(curContext, path);
    }

    @Override
    public List<?> selectNodes(String path) {
        return this.dataSource.selectNodes(path);
    }

    @Override
    public List<?> selectNodes(Object curContext, String path) {
        return this.dataSource.selectNodes(curContext, path);
    }

    @Override
    public Object getRoot() {
        return this.dataSource.getRoot();
    }

    @Override
    public Object getValue(Object o) {
        return this.dataSource.getValue(o);
    }

    @Override
    public void setWrittenObject(Queryable queryable) {
        this.dataSource = queryable;
    }
}

