/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import repast.simphony.integration.BeanBuilder;
import repast.simphony.integration.DataFileElementReader;
import repast.simphony.integration.DataFileElements;
import repast.simphony.integration.DataFileUtils;
import repast.simphony.integration.NewLinePatternConverter;
import repast.simphony.integration.OutputBuilder;
import repast.simphony.integration.Reader;
import repast.simphony.util.RandomAccessScanner;
import simphony.util.messages.MessageCenter;

public class DataFileReader
implements Reader {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(DataFileReader.class);
    private NewLinePatternConverter newLineConverter;
    private String descriptorFileName;
    private String fileToParseName;
    protected Document descriptorDocument;
    private RandomAccessScanner scanner;
    private OutputBuilder<?, ?> outputBuilder;

    public DataFileReader(OutputBuilder<?, ?> outputBuilder) {
        this.outputBuilder = outputBuilder;
    }

    public DataFileReader(Object target) {
        this.outputBuilder = new BeanBuilder(target);
    }

    protected void restore() throws IOException {
        this.scanner.reset();
        this.scanner.popMark();
    }

    protected void mark() throws IOException {
        this.scanner.mark();
    }

    @Override
    public void read() throws IOException, JDOMException {
        this.loadDescriptor();
        this.parseFile();
    }

    private void loadDescriptor() throws IOException, JDOMException {
        this.descriptorDocument = DataFileUtils.loadDescriptor(this.descriptorFileName);
    }

    private void parseFile() throws IOException {
        this.initializeForParse();
        this.handleElement(this.outputBuilder, this.descriptorDocument.getRootElement());
        this.handleChildren(this.outputBuilder, this.descriptorDocument.getRootElement());
    }

    private void initializeForParse() throws IOException {
        File fileToParse = new File(this.fileToParseName);
        if (!fileToParse.exists()) {
            RuntimeException ex = new RuntimeException("DataFileParser.parseFile: Error parsing file (" + this.fileToParseName + "), " + "the file does not exist.");
            msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            throw ex;
        }
        FileChannel channel = new FileInputStream(fileToParse).getChannel();
        this.scanner = new RandomAccessScanner(channel);
        Element rootElement = this.descriptorDocument.getRootElement();
        if (rootElement.getName() != DataFileElements.FILE_DEF.getTag()) {
            RuntimeException ex = new RuntimeException("DataFileParser.parseFile: Error parsing file (" + this.fileToParseName + "), " + "the root node's name wasn't '" + DataFileElements.FILE_DEF.getTag() + "'.");
            msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            throw ex;
        }
        this.outputBuilder.initialize();
    }

    private void handleElement(OutputBuilder outWriter, Element node) throws IOException {
        this.getElementHandler(node).handle(this, outWriter, node);
    }

    private void handleChildren(OutputBuilder outWriter, Element node) throws IOException {
        List childNodes = node.getChildren();
        int i = 0;
        while (i < childNodes.size()) {
            this.handleElement(outWriter, (Element)childNodes.get(i));
            ++i;
        }
    }

    String getValueDelimiter(String delimiter) {
        this.scanner.useDelimiter(delimiter);
        String scannerNext = this.scanner.next();
        return scannerNext;
    }

    String getValuePattern(String pattern) {
        String scannerNext = this.scanner.getNextPattern(pattern);
        return scannerNext;
    }

    String getValueLength(int length) {
        if (length <= 0) {
            return null;
        }
        return this.scanner.getNextLength(length);
    }

    private DataFileElementReader getElementHandler(Element node) {
        return DataFileElementReader.getElementHandler(node);
    }

    public OutputBuilder<?, ?> getoutputBuilder() {
        return this.outputBuilder;
    }

    public void setoutputBuilder(OutputBuilder<?, ?> outputBuilder) {
        this.outputBuilder = outputBuilder;
    }

    public Object getParseResult() {
        return this.outputBuilder.getWrittenObject();
    }

    public String getDescriptorFileName() {
        return this.descriptorFileName;
    }

    public void setDescriptorFileName(String descriptorFileName) {
        this.descriptorFileName = descriptorFileName;
    }

    public String getFileToParseName() {
        return this.fileToParseName;
    }

    public void setFileToParseName(String fileToParseName) {
        this.fileToParseName = fileToParseName;
    }

    public NewLinePatternConverter getNewLineConverter() {
        return this.newLineConverter;
    }

    public void setNewLineConverter(NewLinePatternConverter newLineConverter) {
        this.newLineConverter = newLineConverter;
    }

    public void popMark() {
        this.scanner.popMark();
    }
}

