/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import repast.simphony.integration.ArrayDataTypeHandler;
import repast.simphony.integration.DataFileElements;
import repast.simphony.integration.DataFileWriter;
import repast.simphony.integration.DataTypeHandler;
import repast.simphony.integration.EscapeConverter;
import repast.simphony.integration.Queryable;
import simphony.util.messages.MessageCenter;

public enum DataFileElementWriter {
    FILE_DEF(DataFileElements.FILE_DEF.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element nodeToHandle) {
            writerInst.setNewLineConverter(EscapeConverter.getNewLineConverter(DataFileElements.FILE_DEF_ATTRS.getNewLineType(nodeToHandle)));
        }
    }
    ,
    DATA(DataFileElements.DATA.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element dataDescriptor) {
            DataFileElementWriter.writeData(writerInst, parentContext, dataDescriptor, null);
        }
    }
    ,
    RECORD(DataFileElements.RECORD.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element dataDescriptor) throws IOException {
            int count = DataFileElements.RECORD_ATTRS.getCount(writerInst, dataDescriptor);
            String target = DataFileElements.RECORD_ATTRS.getTarget(writerInst, dataDescriptor);
            List<?> targetNodes = null;
            try {
                targetNodes = writerInst.selectNodes(parentContext, target);
            }
            catch (Exception e) {
                msgCenter.warn((Object)("Could not find any data to write, skipping record with target(" + target + ")."), (Throwable)e, new Object[0]);
                return;
            }
            if (targetNodes == null) {
                msgCenter.warn((Object)("Could not find any data to write, skipping record with target(" + target + ")."), new Object[0]);
                return;
            }
            if (count > 0) {
                this.repeatCount(writerInst, parentContext, dataDescriptor, targetNodes, count);
            } else {
                this.repeatOnAll(writerInst, parentContext, dataDescriptor, targetNodes);
            }
        }

        private void repeatCount(DataFileWriter writerInst, Object dataParent, Element dataDescriptor, Iterable<?> targetNodes, int count) throws IOException {
            Iterator<?> iter = targetNodes.iterator();
            int i = 0;
            while (i < count) {
                this.executeRepeat(writerInst, iter.next(), dataDescriptor);
                ++i;
            }
        }

        private void repeatOnAll(DataFileWriter writerInst, Object dataParent, Element dataDescriptor, Iterable<?> targetNodes) throws IOException {
            for (Object target : targetNodes) {
                this.executeRepeat(writerInst, target, dataDescriptor);
            }
        }

        private void executeRepeat(DataFileWriter writerInst, Object repeatDataObject, Element repeatDescriptor) throws IOException {
            List childDescriptors = repeatDescriptor.getChildren();
            for (Element subDescriptor : childDescriptors) {
                3.getElementHandler(subDescriptor).handle(writerInst, repeatDataObject, subDescriptor);
            }
        }
    }
    ,
    ARRAY(DataFileElements.ARRAY.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element dataDescriptor) throws IOException {
            int rows = DataFileElements.ARRAY_ATTRS.getRows(writerInst, dataDescriptor);
            int cols = DataFileElements.ARRAY_ATTRS.getCols(writerInst, dataDescriptor);
            String colDelimiter = DataFileElements.ARRAY_ATTRS.getColDelimiter(writerInst, dataDescriptor);
            String rowDelimiter = DataFileElements.ARRAY_ATTRS.getRowDelimiter(writerInst, dataDescriptor);
            String target = DataFileElements.ARRAY_ATTRS.getTarget(writerInst, dataDescriptor);
            String type = DataFileElements.ARRAY_ATTRS.getType(writerInst, dataDescriptor);
            Object data = null;
            try {
                data = writerInst.getValue(writerInst.selectNode(parentContext, target));
            }
            catch (Exception e) {
                msgCenter.warn((Object)("Could not find any data to write, skipping array with target(" + target + ")."), (Throwable)e, new Object[0]);
                return;
            }
            if (data == null) {
                msgCenter.warn((Object)("Could not find any data to write, skipping array with target(" + target + ")."), new Object[0]);
                return;
            }
            ArrayDataTypeHandler.ArrayHandler handler = ArrayDataTypeHandler.getDataType(type).getHandler(rows, cols, data);
            if (rows <= 0) {
                rows = handler.getRowCount();
            }
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < cols - 1) {
                    writerInst.writeValueDelimiter(handler.getValueString(i, j), colDelimiter);
                    ++j;
                }
                writerInst.writeValueDelimiter(handler.getValueString(i, cols - 1), rowDelimiter);
                ++i;
            }
        }
    }
    ,
    TABLE(DataFileElements.TABLE.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element dataDescriptor) throws IOException {
            int rows = DataFileElements.TABLE_ATTRS.getRows(writerInst, dataDescriptor);
            Element columns = DataFileElements.TABLE_ATTRS.getColumns(dataDescriptor);
            try {
                Hashtable<Element, ArrayDataTypeHandler.ArrayHandler> handlerMap = new Hashtable<Element, ArrayDataTypeHandler.ArrayHandler>();
                List dataElements = columns.getChildren();
                int minLength = Integer.MAX_VALUE;
                for (Element dataElement : dataElements) {
                    String type = DataFileElements.DATA_ATTRS.getType(writerInst, dataElement);
                    String target = DataFileElements.DATA_ATTRS.getTarget(writerInst, dataElement);
                    Object value = writerInst.getValue(writerInst.selectNode(parentContext, target));
                    handlerMap.put(dataElement, ArrayDataTypeHandler.getDataType(type).getHandler(0, 1, value));
                    minLength = Math.min(minLength, ((ArrayDataTypeHandler.ArrayHandler)handlerMap.get(dataElement)).getRowCount());
                }
                if (rows <= 0) {
                    rows = minLength;
                }
                int i = 0;
                while (i < rows) {
                    for (Element dataElement : dataElements) {
                        DataFileElementWriter.writeData(writerInst, parentContext, dataElement, ((ArrayDataTypeHandler.ArrayHandler)handlerMap.get(dataElement)).getValueString(i, 0));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                msgCenter.warn((Object)"Exception while working with table, skipping table", (Throwable)e, new Object[0]);
                return;
            }
        }
    }
    ,
    BRANCH(DataFileElements.BRANCH.getTag()){

        @Override
        public void handle(DataFileWriter writerInst, Object parentContext, Element dataDescriptor) throws IOException {
            writerInst.mark();
            try {
                List childDescriptors = dataDescriptor.getChildren();
                for (Element subDescriptor : childDescriptors) {
                    6.getElementHandler(subDescriptor).handle(writerInst, parentContext, subDescriptor);
                }
                writerInst.popMark();
            }
            catch (Exception e) {
                writerInst.reset();
            }
        }
    };

    private static final MessageCenter msgCenter;
    public final String tag;

    static {
        msgCenter = MessageCenter.getMessageCenter(DataFileElementWriter.class);
    }

    private DataFileElementWriter(String descriptor) {
        this.tag = descriptor;
    }

    public static DataFileElementWriter getElementHandler(Element nodeToHandle) {
        String nodeName = nodeToHandle.getName();
        DataFileElementWriter[] dataFileElementWriterArray = DataFileElementWriter.values();
        int n = dataFileElementWriterArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFileElementWriter handler = dataFileElementWriterArray[n2];
            if (handler.tag.equalsIgnoreCase(nodeName)) {
                return handler;
            }
            ++n2;
        }
        RuntimeException ex = new RuntimeException("Error reading node's type. Could not interpret nodeName(" + nodeName + ").");
        msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        throw ex;
    }

    private static void writeData(DataFileWriter writerInst, Object parentContext, Element dataDescriptor, Object data) {
        String type = DataFileElements.DATA_ATTRS.getType(writerInst, dataDescriptor);
        String target = DataFileElements.DATA_ATTRS.getTarget(writerInst, dataDescriptor);
        if (target == null) {
            RuntimeException ex = new RuntimeException("Target cannot be null.\n\ttype(" + type + "), target(" + target + ")");
            msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            throw ex;
        }
        int length = DataFileElements.DATA_ATTRS.getLength(writerInst, dataDescriptor);
        String delimiter = DataFileElements.DATA_ATTRS.getDelimiter(writerInst, dataDescriptor, type);
        String pattern = DataFileElements.DATA_ATTRS.getPattern(writerInst, dataDescriptor);
        if (data == null && target.equals("null")) {
            switch (DataTypeHandler.getDataType(type)) {
                case STRING: {
                    if (pattern != null) {
                        data = DataFileElements.DATA_ATTRS.getPattern(writerInst, dataDescriptor);
                        break;
                    }
                    if (length > 0) {
                        data = DataFileElementWriter.getDefaultDataLength(length, type);
                        break;
                    }
                    data = "";
                    msgCenter.warn((Object)"Writing a data value and found no pattern nor length.  Defaulting to empty data.", new Object[0]);
                    break;
                }
                default: {
                    if (length > 0) {
                        data = DataFileElementWriter.getDefaultDataLength(length, type);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (data == null) {
            data = DataFileElementWriter.getData(writerInst, parentContext, target);
        }
        if (pattern != null) {
            DataFileElementWriter.writeDataPattern(writerInst, data, pattern, type);
        } else {
            if (delimiter == null) {
                delimiter = "";
            }
            DataFileElementWriter.writeDataDelimiter(writerInst, data, delimiter);
        }
    }

    private static Object getDefaultDataLength(int length, String type) {
        switch (DataTypeHandler.getDataType(type)) {
            case STRING: {
                return DataFileElementWriter.getStringLength(length, ' ');
            }
            case DOUBLE: {
                return DataFileElementWriter.getStringLength(length, '0');
            }
            case INT: {
                return DataFileElementWriter.getStringLength(length, '0');
            }
        }
        return null;
    }

    private static Object getStringLength(int length, char charToUse) {
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            builder.append(charToUse);
            ++i;
        }
        return builder.toString();
    }

    private static Object getData(Queryable dataSource, Object curContext, String target) {
        return dataSource.getValue(dataSource.selectNode(curContext, target));
    }

    private static void writeDataDelimiter(DataFileWriter writerInst, Object data, String delimiter) {
        writerInst.writeValueDelimiter(data, delimiter);
    }

    private static void writeDataPattern(DataFileWriter writerInst, Object data, String pattern, String type) {
        writerInst.writeValuePattern(data, type, pattern);
    }

    public abstract void handle(DataFileWriter var1, Object var2, Element var3) throws IOException;

    /* synthetic */ DataFileElementWriter(String string, int n, String string2, DataFileElementWriter dataFileElementWriter) {
        this(string2);
    }
}

