/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import repast.simphony.integration.ArrayDataTypeHandler;
import repast.simphony.integration.DataContent;
import repast.simphony.integration.DataFileElements;
import repast.simphony.integration.DataFileReader;
import repast.simphony.integration.DataTypeHandler;
import repast.simphony.integration.JDOMBuilder;
import repast.simphony.integration.JDOMXPathUtils;
import repast.simphony.integration.NewLinePatternConverter;
import repast.simphony.integration.OutputBuilder;
import repast.simphony.integration.Queryable;
import simphony.util.messages.MessageCenter;

public enum DataFileElementReader {
    FILE_DEF(DataFileElements.FILE_DEF.getTag()){

        @Override
        public Object[] handle(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element nodeToHandle) {
            parserInst.setNewLineConverter(NewLinePatternConverter.getNewLineConverter(DataFileElements.FILE_DEF_ATTRS.getNewLineType(nodeToHandle)));
            return null;
        }
    }
    ,
    DATA(DataFileElements.DATA.getTag()){

        @Override
        public Object[] handle(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element node) {
            Object data;
            String target;
            block7: {
                String pattern;
                String delimiter;
                int length;
                String type;
                block6: {
                    type = DataFileElements.DATA_ATTRS.getType(outWriter, node);
                    target = DataFileElements.DATA_ATTRS.getTarget(outWriter, node);
                    length = DataFileElements.DATA_ATTRS.getLength(outWriter, node);
                    delimiter = this.getDelimiter(parserInst.getNewLineConverter(), outWriter, node, type);
                    pattern = this.getPattern(parserInst.getNewLineConverter(), outWriter, node);
                    if (target == null) {
                        RuntimeException ex = new RuntimeException("Target cannot be null.\n\ttype(" + type + "), target(" + target + "), length(" + length + "), delimiter(" + delimiter + "), pattern(" + pattern + ")");
                        msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                        throw ex;
                    }
                    if (delimiter == null && pattern == null && length <= 0) {
                        pattern = this.getDefaultPattern(type);
                    }
                    if (length > 0 || delimiter != null || pattern != null) break block6;
                    msgCenter.warn((Object)("DATA.handle: found an invalid element. An element must contain a length, delimiter, or pattern. \n\ttype(" + type + "), target(" + target + "), length(" + length + "), delimiter(" + delimiter + "), pattern(" + pattern + ")"), new Object[0]);
                    return null;
                }
                data = length > 0 ? this.getDataWithLength(parserInst, type, length) : (pattern != null ? this.getDataWithPattern(parserInst, type, pattern) : this.getDataWithDelimiter(parserInst, type, delimiter));
                if (!target.equals("null")) break block7;
                return null;
            }
            Object output = outWriter.writeValue(target, data);
            msgCenter.debug((Object)("Store (" + target + ", " + data + "): " + data.getClass() + " "), new Object[0]);
            return new Object[]{output};
        }

        private String getDefaultPattern(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("int")) {
                return INT_PATTERN;
            }
            if (type.equals("double")) {
                return DOUBLE_PATTERN;
            }
            return null;
        }

        private String getPattern(NewLinePatternConverter newLineConverter, Queryable outWriter, Element node) {
            String pattern = DataFileElements.DATA_ATTRS.getPattern(outWriter, node);
            if (pattern != null) {
                return newLineConverter.convert(pattern);
            }
            return null;
        }

        private String getDelimiter(NewLinePatternConverter newLineConverter, Queryable outWriter, Element node, String type) {
            String delimiter = DataFileElements.DATA_ATTRS.getDelimiter(outWriter, node, type);
            if (delimiter == null) {
                delimiter = this.getDefaultDelimiter(type);
            }
            if (delimiter != null) {
                return newLineConverter.convert(delimiter);
            }
            return null;
        }

        private String getDefaultDelimiter(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("string")) {
                return STRING_DELIMITER;
            }
            return null;
        }

        private Object getDataWithDelimiter(DataFileReader parserInst, String type, String delimiter) {
            return DataTypeHandler.getDataType(type).convert(parserInst.getValueDelimiter(delimiter));
        }

        private Object getDataWithPattern(DataFileReader parserInst, String type, String pattern) {
            return DataTypeHandler.getDataType(type).convert(parserInst.getValuePattern(pattern));
        }

        private Object getDataWithLength(DataFileReader parserInst, String type, int length) {
            return DataTypeHandler.getDataType(type).convert(parserInst.getValueLength(length));
        }
    }
    ,
    RECORD(DataFileElements.RECORD.getTag()){

        @Override
        public Object[] handle(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element nodeToHandle) throws IOException {
            int count = DataFileElements.RECORD_ATTRS.getCount(outWriter, nodeToHandle);
            String target = DataFileElements.RECORD_ATTRS.getTarget(outWriter, nodeToHandle);
            ArrayList<Object> repeatNodes = null;
            try {
                repeatNodes = count > 0 ? this.repeatCount(parserInst, outWriter, nodeToHandle, target, count) : this.repeatTilFail(parserInst, outWriter, nodeToHandle, target);
                return repeatNodes.toArray(new Object[repeatNodes.size()]);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw ex;
            }
        }

        private ArrayList<Object> repeatCount(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element nodeToHandle, String target, int count) throws IOException {
            ArrayList<Object> records = new ArrayList<Object>(count);
            List subContent = nodeToHandle.getChildren();
            int i = 0;
            while (i < count) {
                Object created = outWriter.createAndGoInto(target);
                for (Element subNode : subContent) {
                    3.getElementHandler(subNode).handle(parserInst, outWriter, subNode);
                }
                outWriter.goUp();
                records.add(created);
                ++i;
            }
            return records;
        }

        private ArrayList<Object> repeatTilFail(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element nodeToHandle, String target) throws IOException {
            ArrayList<Object> records = new ArrayList<Object>();
            Element branchNode = new Element(3.BRANCH.tag);
            ArrayList children = new ArrayList(nodeToHandle.getChildren());
            for (Element child : children) {
                child.detach();
                branchNode.addContent((Content)child);
            }
            while (true) {
                Object created = outWriter.createAndGoInto(target);
                Object[] subData = 3.getElementHandler(branchNode).handle(parserInst, outWriter, branchNode);
                if (subData == null) break;
                outWriter.goUp();
                records.add(created);
            }
            outWriter.detach();
            for (Element child : children) {
                child.detach();
                nodeToHandle.addContent((Content)child);
            }
            if (records.size() == 0) {
                return null;
            }
            return records;
        }
    }
    ,
    TABLE(DataFileElements.TABLE.getTag()){

        /*
         * Unable to fully structure code
         */
        @Override
        public Object[] handle(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element node) throws IOException {
            columnsElement = DataFileElements.TABLE_ATTRS.getColumns(node);
            dataElements = new ArrayList<Element>(columnsElement.getChildren());
            try {
                for (Element dataElement : dataElements) {
                    dataElement.detach();
                }
                recordElement = this.getRecordElement(parserInst, outWriter, node, dataElements);
                rows = 4.fakeRecord(parserInst, outWriter, recordElement);
                table = new Hashtable<Element, ArrayDataTypeHandler.ArrayHandler>(rows.size());
                for (Element dataElement : dataElements) {
                    type = DataFileElements.DATA_ATTRS.getType(outWriter, dataElement);
                    table.put(dataElement, ArrayDataTypeHandler.getDataType(type).getHandler(rows.size(), 1));
                }
                i = 0;
                while (i < rows.size()) {
                    row = rows.get(i);
                    for (Element dataElement : dataElements) {
                        value = JDOMXPathUtils.getValue(row.getChild(DataFileElements.DATA_ATTRS.getTarget(outWriter, dataElement)));
                        ((ArrayDataTypeHandler.ArrayHandler)table.get(dataElement)).setValue(i, 0, value);
                    }
                    ++i;
                }
                returnVal = new Object[dataElements.size()];
                i = 0;
                while (i < dataElements.size()) {
                    dataElement = (Element)dataElements.get(i);
                    returnVal[i] = outWriter.writeValue(DataFileElements.DATA_ATTRS.getTarget(outWriter, dataElement), ((ArrayDataTypeHandler.ArrayHandler)table.get(dataElement)).getValue());
                    dataElement.detach();
                    columnsElement.addContent((Content)dataElement);
                    ++i;
                }
                return returnVal;
            }
            catch (RuntimeException ex) {
                ** for (dataElement : dataElements)
            }
lbl-1000:
            // 1 sources

            {
                dataElement.detach();
                continue;
            }
lbl42:
            // 1 sources

            columnsElement.addContent(dataElements);
            throw ex;
        }

        private Element getRecordElement(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element tableElement, List<Element> dataElements) {
            Element element = new Element(DataFileElements.RECORD.getTag());
            int rows = DataFileElements.TABLE_ATTRS.getRows(outWriter, tableElement);
            element.setAttribute("target", DataFileElementReader.FAKE_TARGET);
            if (rows >= 0) {
                element.setAttribute("count", Integer.toString(rows));
            }
            element.addContent(dataElements);
            return element;
        }
    }
    ,
    ARRAY(DataFileElements.ARRAY.getTag()){

        @Override
        public Object[] handle(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element node) throws IOException {
            String type = DataFileElements.ARRAY_ATTRS.getType(outWriter, node);
            String target = DataFileElements.ARRAY_ATTRS.getTarget(outWriter, node);
            int cols = DataFileElements.ARRAY_ATTRS.getCols(outWriter, node);
            Element recordElement = this.getRecordElement(parserInst, outWriter, node);
            List<Element> rows = 5.fakeRecord(parserInst, outWriter, recordElement);
            ArrayDataTypeHandler.ArrayHandler handler = ArrayDataTypeHandler.getDataType(type).getHandler(rows.size(), cols);
            int row = 0;
            while (row < rows.size()) {
                Element curRow = rows.get(row);
                List curCols = curRow.getChildren();
                int j = 0;
                while (j < curCols.size()) {
                    handler.setValue(row, j, ((DataContent)curRow.getChild(this.getColName(j)).getContent(0)).getValue());
                    ++j;
                }
                ++row;
            }
            return new Object[]{outWriter.writeValue(target, handler.getValue())};
        }

        private String getColName(int col) {
            return "col" + col;
        }

        private Element getRecordElement(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element arrayElement) {
            Element element = new Element(DataFileElements.RECORD.getTag());
            String target = DataFileElements.ARRAY_ATTRS.getTarget(outWriter, arrayElement);
            String type = DataFileElements.ARRAY_ATTRS.getType(outWriter, arrayElement);
            String rowDelimiter = DataFileElements.ARRAY_ATTRS.getRowDelimiter(outWriter, arrayElement);
            String colDelimiter = DataFileElements.ARRAY_ATTRS.getColDelimiter(outWriter, arrayElement);
            int rows = DataFileElements.ARRAY_ATTRS.getRows(outWriter, arrayElement);
            element.setAttribute("target", target);
            if (rows >= 0) {
                element.setAttribute("count", Integer.toString(rows));
            }
            int cols = DataFileElements.ARRAY_ATTRS.getCols(outWriter, arrayElement);
            int i = 0;
            while (i < cols - 1) {
                element.addContent((Content)this.getDataElement(this.getColName(i), type, colDelimiter));
                ++i;
            }
            element.addContent((Content)this.getDataElement(this.getColName(cols - 1), type, rowDelimiter));
            return element;
        }

        private Element getDataElement(String target, String type, String delimiter) {
            Element element = new Element(DataFileElements.DATA.getTag());
            element.setAttribute("target", target);
            element.setAttribute("delimiter", delimiter);
            element.setAttribute("type", type);
            return element;
        }
    }
    ,
    BRANCH(DataFileElements.BRANCH.getTag()){

        public Object[] handle(DataFileReader parserInst, OutputBuilder outWriter, Element nodeToHandle) throws IOException {
            ArrayList<Object> subData = new ArrayList<Object>();
            try {
                parserInst.mark();
                ArrayList subContent = new ArrayList(nodeToHandle.getChildren());
                for (Element subNode : subContent) {
                    Object[] data = 6.getElementHandler(subNode).handle(parserInst, outWriter, subNode);
                    if (data == null) continue;
                    Object[] objectArray = data;
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object sub = objectArray[n2];
                        subData.add(sub);
                        ++n2;
                    }
                }
                parserInst.popMark();
                return subData.toArray(new Object[subData.size()]);
            }
            catch (Exception ex) {
                outWriter.detach(subData);
                parserInst.restore();
                msgCenter.debug((Object)"BRANCH.handle: branch failed", new Object[]{ex});
                return null;
            }
        }
    };

    public static String STRING_DELIMITER;
    public static String DOUBLE_PATTERN;
    public static String INT_PATTERN;
    private static final String FAKE_TARGET = "FAKE_TARGET";
    private static final MessageCenter msgCenter;
    public final String tag;

    static {
        STRING_DELIMITER = "\n";
        DOUBLE_PATTERN = "(\\+|\\-|)\\d*(\\.\\d*|\\.|)(E(\\+|-|)\\d+|)";
        INT_PATTERN = "(\\+|\\-|)\\d+";
        msgCenter = MessageCenter.getMessageCenter(DataFileElementReader.class);
    }

    private DataFileElementReader(String descriptor) {
        this.tag = descriptor;
    }

    public static DataFileElementReader getElementHandler(Element nodeToHandle) {
        String nodeName = nodeToHandle.getName();
        DataFileElementReader[] dataFileElementReaderArray = DataFileElementReader.values();
        int n = dataFileElementReaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFileElementReader handler = dataFileElementReaderArray[n2];
            if (handler.tag.equalsIgnoreCase(nodeName)) {
                return handler;
            }
            ++n2;
        }
        RuntimeException ex = new RuntimeException("Error reading node's type. Could not interpret nodeName(" + nodeName + ").");
        msgCenter.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
        throw ex;
    }

    public abstract Object[] handle(DataFileReader var1, OutputBuilder<?, ?> var2, Element var3) throws IOException;

    public static List<Element> fakeRecord(DataFileReader parserInst, OutputBuilder<?, ?> outWriter, Element recordElement) throws IOException {
        JDOMBuilder jdomWriter = new JDOMBuilder();
        jdomWriter.initialize();
        DataFileElementReader.getElementHandler(recordElement).handle(parserInst, jdomWriter, recordElement);
        return jdomWriter.selectNodes("/fileDef/*");
    }

    /* synthetic */ DataFileElementReader(String string, int n, String string2, DataFileElementReader dataFileElementReader) {
        this(string2);
    }
}

