/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import org.apache.commons.jxpath.JXPathContext;
import repast.simphony.integration.DemoData;
import repast.simphony.integration.FileDef;
import repast.simphony.integration.JXPathUtils;

public class BeanXPathTest {
    public static void test1() {
        Root root = new Root();
        JXPathContext rootContext = JXPathContext.newContext((Object)root);
        rootContext.setLenient(true);
        JXPathContext childContext = JXPathContext.newContext((JXPathContext)rootContext, (Object)root.child);
        childContext.setLenient(true);
        JXPathContext subChildContext = JXPathContext.newContext((JXPathContext)childContext, (Object)root.child.subChild);
        subChildContext.setLenient(true);
        System.out.println("**********************");
        System.out.println("Nested classes and contexts Test");
        System.out.println("subChildContext:");
        BeanXPathTest.test(rootContext, subChildContext, "subChildProperty");
        BeanXPathTest.test(rootContext, subChildContext, "./subChildProperty");
        BeanXPathTest.test(rootContext, subChildContext, ".");
        BeanXPathTest.test(rootContext, subChildContext, "../.");
        BeanXPathTest.test(rootContext, subChildContext, "//subChildProperty");
        BeanXPathTest.test(rootContext, subChildContext, "/child/subChild/subChildProperty");
        BeanXPathTest.test(rootContext, subChildContext, "/child/subChild/@subChildProperty");
        BeanXPathTest.test(rootContext, subChildContext, "/");
        BeanXPathTest.test(rootContext, subChildContext, "//rootProperty");
        BeanXPathTest.test(rootContext, subChildContext, "/rootProperty");
        BeanXPathTest.test(rootContext, subChildContext, "/RootProperty");
        BeanXPathTest.test(rootContext, subChildContext, "../subChild/subChildProperty");
        System.out.println("rootContext:");
        BeanXPathTest.test(rootContext, subChildContext, "/rootProperty");
        BeanXPathTest.test(rootContext, rootContext, "child/subChild/subChildProperty");
        BeanXPathTest.test(rootContext, rootContext, "//subChildProperty");
    }

    public static void testDemoData() {
        DemoData data = new DemoData();
        data.title = "titleValue";
        data.date = "dateValue";
        data.spectrometerType = 1;
        data.xAxisType = "xAxisTypeValue";
        data.numXCols = 2;
        data.numCalibrationRuns = 3;
        JXPathContext context = JXPathContext.newContext((Object)data);
        context.setLenient(true);
        System.out.println("**********************");
        System.out.println("DemoData Test");
        BeanXPathTest.test(context, context, "/");
        BeanXPathTest.test(context, context, "/demoData");
        BeanXPathTest.test(context, context, "/title");
        BeanXPathTest.test(context, context, "title");
        BeanXPathTest.test(context, context, "numXCols");
        BeanXPathTest.test(context, context, "demoData/numXCols");
        BeanXPathTest.test(context, context, "/numXCols");
        BeanXPathTest.test(context, context, "//numXCols");
        BeanXPathTest.test(context, context, "../numXCols");
    }

    private static void test(JXPathContext rootContext, JXPathContext context, String path) {
        System.out.println("\t" + path + ":\t (" + JXPathUtils.getXPathNode(rootContext, context, path) + ")");
    }

    public static void testDemoDataFileDef() {
        DemoData data = new DemoData();
        FileDef boundRoot = new FileDef(data);
        data.title = "titleValue";
        data.date = "dateValue";
        data.spectrometerType = 1;
        data.xAxisType = "xAxisTypeValue";
        data.numXCols = 2;
        data.numCalibrationRuns = 3;
        JXPathContext rootContext = JXPathContext.newContext((Object)boundRoot);
        rootContext.setLenient(true);
        JXPathContext context = JXPathContext.newContext((Object)data);
        context.setLenient(true);
        System.out.println("**********************");
        System.out.println("Bound DemoData Test");
        BeanXPathTest.test(rootContext, context, "/");
        BeanXPathTest.test(rootContext, context, "/fileDef");
        BeanXPathTest.test(rootContext, context, "fileDef");
        BeanXPathTest.test(rootContext, context, "/fileDef");
        BeanXPathTest.test(rootContext, context, "fileDef");
        BeanXPathTest.test(rootContext, context, "/DemoData");
        BeanXPathTest.test(rootContext, context, "DemoData");
        BeanXPathTest.test(rootContext, context, "title");
        BeanXPathTest.test(rootContext, context, "numXCols");
        BeanXPathTest.test(rootContext, context, "DemoData/numXCols");
        BeanXPathTest.test(rootContext, context, "/fileDef/numXCols");
        BeanXPathTest.test(rootContext, context, "/numXCols");
        BeanXPathTest.test(rootContext, context, "//numXCols");
        BeanXPathTest.test(rootContext, context, "../numXCols");
        BeanXPathTest.test(rootContext, context, "/fileDef/fileDef/title");
        BeanXPathTest.test(rootContext, context, "numXCols");
        BeanXPathTest.test(rootContext, context, "fileDef/numXCols");
        BeanXPathTest.test(rootContext, context, "fileDef/fileDef/title");
    }

    public static void main(String[] args) {
        BeanXPathTest.test1();
        BeanXPathTest.testDemoData();
        BeanXPathTest.testDemoDataFileDef();
    }

    public static class Child {
        SubChild subChild = new SubChild();

        public SubChild getSubChild() {
            return this.subChild;
        }

        public String getChildProperty() {
            return "childValue";
        }
    }

    public static class Root {
        Child child = new Child();

        public Child getChild() {
            return this.child;
        }

        public String getRootProperty() {
            return "rootPropertyValue";
        }
    }

    public static class SubChild {
        public String getSubChildProperty() {
            return "subChildValue";
        }
    }
}

