/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.util.Iterator;
import junitx.util.PrivateAccessor;
import org.apache.commons.jxpath.JXPathContext;
import org.jmock.MockObjectTestCase;
import repast.simphony.integration.BeanQueryer;
import repast.simphony.integration.FileDef;

public class BeanQueryerTest
extends MockObjectTestCase {
    private BeanQueryer queryer;
    private Object root;
    private JXPathContext rootObjectContext;
    static Object field1 = "field1Value";
    static Object field2 = "field2Value";

    protected void setUp() throws Exception {
        super.setUp();
        this.root = new QueriedClass();
        this.rootObjectContext = JXPathContext.newContext((Object)this.root);
        this.queryer = new BeanQueryer(this.root);
    }

    public void testBeanQueryer() throws NoSuchFieldException {
        BeanQueryerTest.assertSame((Object)this.root, (Object)((FileDef)((JXPathContext)PrivateAccessor.getField((Object)this.queryer, (String)"rootContext")).getContextBean()).getFileDef());
    }

    public void testSelectNodeString() {
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode("/fileDef/field1"));
        BeanQueryerTest.assertEquals((Object)field2, (Object)this.queryer.selectNode("/fileDef/field2"));
        BeanQueryerTest.assertNull((Object)this.queryer.selectNode("/fileDef/field101293asfasf"));
    }

    public void testSelectNodeObjectString() {
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode(this.rootObjectContext, "/fileDef/field1"));
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode(this.rootObjectContext, "field1"));
        BeanQueryerTest.assertNull((Object)this.queryer.selectNode(this.rootObjectContext, "/fileDef/field101293asfasf"));
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode(this.rootObjectContext.getContextBean(), "/fileDef/field1"));
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode(this.rootObjectContext.getContextBean(), "field1"));
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.selectNode(this.queryer.selectNode("/"), "/fileDef/field1"));
    }

    public void testSelectNodesString() {
        Iterator<?> iter = this.queryer.selectNodes("/fileDef/field1").iterator();
        BeanQueryerTest.assertEquals((Object)field1, iter.next());
        BeanQueryerTest.assertFalse((boolean)iter.hasNext());
        iter = this.queryer.selectNodes("/fileDef/field2").iterator();
        BeanQueryerTest.assertEquals((Object)field2, iter.next());
        BeanQueryerTest.assertFalse((boolean)iter.hasNext());
        BeanQueryerTest.assertFalse((boolean)this.queryer.selectNodes("/fileDef/field101293asfasf").iterator().hasNext());
    }

    public void testSelectNodesObjectString() {
        Iterator<?> iter = this.queryer.selectNodes(this.rootObjectContext, "/fileDef/field1").iterator();
        BeanQueryerTest.assertEquals((Object)field1, iter.next());
        BeanQueryerTest.assertFalse((boolean)iter.hasNext());
        iter = this.queryer.selectNodes(this.rootObjectContext, "field1").iterator();
        BeanQueryerTest.assertEquals((Object)field1, iter.next());
        BeanQueryerTest.assertFalse((boolean)iter.hasNext());
        BeanQueryerTest.assertFalse((boolean)this.queryer.selectNodes("field101293asfasf").iterator().hasNext());
        iter = this.queryer.selectNodes(this.rootObjectContext.getContextBean(), "/fileDef/field1").iterator();
        BeanQueryerTest.assertEquals((Object)field1, iter.next());
        BeanQueryerTest.assertFalse((boolean)iter.hasNext());
    }

    public void testGetRoot() {
        BeanQueryerTest.assertSame((Object)this.root, (Object)((FileDef)this.queryer.getRoot()).getFileDef());
    }

    public void testGetValue() {
        BeanQueryerTest.assertEquals((Object)field1, (Object)this.queryer.getValue(field1));
        BeanQueryerTest.assertNull((Object)this.queryer.getValue(null));
    }

    public static class QueriedClass {
        public Object getField1() {
            return field1;
        }

        public Object getField2() {
            return field2;
        }
    }
}

