/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Stack;
import org.apache.commons.jxpath.JXPathContext;
import repast.simphony.integration.DataFileUtils;
import repast.simphony.integration.JXPathUtils;
import repast.simphony.integration.ObjectHolder;
import repast.simphony.integration.OutputBuilder;
import repast.simphony.util.ClassUtilities;
import simphony.util.messages.MessageCenter;

public class BeanBuilder
implements OutputBuilder<ObjectHolder, Object> {
    private MessageCenter msgCenter = MessageCenter.getMessageCenter(BeanBuilder.class);
    private Class<?> rootBeanClass;
    private Object root;
    private Object curObject;
    private Stack<ObjectHolder> objectPath;
    private JXPathContext curContext;
    private JXPathContext rootContext;

    public BeanBuilder() {
        this(null);
    }

    public BeanBuilder(Object target) {
        this(null);
        this.root = target;
    }

    public BeanBuilder(Class<?> rootBeanClass) {
        this.rootBeanClass = rootBeanClass;
        this.objectPath = new Stack();
    }

    public void setRootBeanClass(Class<?> rootBeanClass) {
        this.rootBeanClass = rootBeanClass;
    }

    public Class getRootBeanClass() {
        return this.rootBeanClass;
    }

    private Object instantiate(Class<?> toInstantiate) {
        try {
            return toInstantiate.newInstance();
        }
        catch (InstantiationException ex) {
            this.msgCenter.warn((Object)("Error instantiating class(" + toInstantiate + ")."), (Throwable)ex, new Object[0]);
            return null;
        }
        catch (IllegalAccessException ex) {
            this.msgCenter.warn((Object)("Error instantiating class(" + toInstantiate + ")."), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    private Method findAddMethod(Class clazz, String name) {
        return ClassUtilities.findFirstMethodWithArgs((Class)clazz, (String)("add" + ClassUtilities.getPropertyName((String)name)), (int)1);
    }

    private Method findRemoveMethod(Class clazz, String name) {
        return ClassUtilities.findFirstMethodWithArgs((Class)clazz, (String)("remove" + ClassUtilities.getPropertyName((String)name)), (int)1);
    }

    @Override
    public ObjectHolder createAndGoInto(String name) {
        Object parentObj = DataFileUtils.findExplicitTargetParent(this, name);
        if (parentObj == null) {
            parentObj = this.curObject;
        }
        name = DataFileUtils.getName(name);
        Method addMethod = this.findAddMethod(parentObj.getClass(), name);
        if (addMethod == null) {
            RuntimeException ex = new RuntimeException("Couldn't find add method for name(" + name + ").");
            this.msgCenter.error((Object)"Couldn't find add method", (Throwable)ex, new Object[0]);
            throw ex;
        }
        Class<?> argType = addMethod.getParameterTypes()[0];
        Object arg = this.instantiate(argType);
        try {
            addMethod.invoke(this.curObject, arg);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ObjectHolder holder = new ObjectHolder(this.curObject, name, arg, ObjectHolder.StorageType.CHILD);
        this.curObject = arg;
        this.curContext = this.getContext(this.curObject);
        this.objectPath.push(holder);
        return holder;
    }

    private JXPathContext getContext(Object obj) {
        JXPathContext context = this.curContext != null ? JXPathContext.newContext((JXPathContext)this.curContext, (Object)obj) : JXPathContext.newContext((Object)obj);
        context.setLenient(true);
        return context;
    }

    @Override
    public void goUp() {
        this.curObject = this.objectPath.pop().getParent();
        this.curContext = this.curContext.getParentContext();
    }

    @Override
    public void goRoot() {
        this.curObject = this.root;
        this.curContext = this.rootContext;
        this.objectPath.clear();
    }

    @Override
    public ObjectHolder writeValue(String name, Object value) {
        Object parentObj = DataFileUtils.findExplicitTargetParent(this, name);
        if (parentObj == null) {
            parentObj = this.curObject;
        }
        name = DataFileUtils.getName(name);
        ObjectHolder holder = new ObjectHolder(parentObj, name, value, ObjectHolder.StorageType.VALUE);
        if (!ClassUtilities.setValue((Object)parentObj, (String)name, (Object)value)) {
            this.msgCenter.warn((Object)("There was an error setting value(" + value + ") on object(" + this.curObject + ") + with value name(" + name + ")"), new Object[0]);
        }
        return holder;
    }

    @Override
    public Object getWrittenObject() {
        return this.root;
    }

    @Override
    public void detach() {
        if (this.curObject == this.root) {
            RuntimeException ex = new RuntimeException("Cannot detach root object");
            this.msgCenter.error((Object)"Cannot detach root object", (Throwable)ex, new Object[0]);
            throw ex;
        }
        ObjectHolder top = this.objectPath.pop();
        this.curObject = top.getParent();
        this.remove(this.curObject, top.getName(), top.getValue(), top.getStorageType());
    }

    private void remove(Object parent, String name, Object value, ObjectHolder.StorageType storageType) {
        switch (storageType) {
            case CHILD: {
                this.removeChild(parent, name, value);
                break;
            }
            case VALUE: {
                this.removeValue(parent, name);
            }
        }
    }

    private void removeValue(Object parent, String name) {
        ClassUtilities.setValue((Object)parent, (String)name, null);
    }

    private void removeChild(Object parent, String name, Object value) {
        try {
            this.findRemoveMethod(parent.getClass(), name).invoke(parent, value);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void detach(Iterable<ObjectHolder> objsToDetach) {
        for (ObjectHolder holder : objsToDetach) {
            this.remove(holder.getParent(), holder.getName(), holder.getValue(), holder.getStorageType());
        }
    }

    @Override
    public void initialize() {
        try {
            if (this.root == null) {
                this.root = this.instantiate(this.rootBeanClass);
            }
            this.buildRootContext();
            this.goRoot();
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't instantiate root class", ex);
        }
    }

    private void buildRootContext() {
        this.curContext = null;
        this.curContext = this.rootContext = JXPathUtils.createRootContext(this.root, true);
    }

    @Override
    public Object selectNode(String path) {
        return this.selectNode(this.curContext, path);
    }

    @Override
    public Object selectNode(Object curContext, String path) {
        if (path == null || curContext == null) {
            return null;
        }
        JXPathContext jxPathContext = curContext instanceof JXPathContext ? (JXPathContext)curContext : JXPathContext.newContext((Object)curContext);
        try {
            return JXPathUtils.getXPathNode(this.rootContext, jxPathContext, path);
        }
        catch (Exception ex) {
            this.msgCenter.info((Object)("Error evaluating path(" + path + ")"), new Object[0]);
            return null;
        }
    }

    @Override
    public List<?> selectNodes(String path) {
        return this.selectNodes(this.curContext, path);
    }

    @Override
    public List<?> selectNodes(Object curContext, String path) {
        if (path == null || curContext == null) {
            return null;
        }
        JXPathContext jxPathContext = curContext instanceof JXPathContext ? (JXPathContext)curContext : JXPathContext.newContext((Object)curContext);
        try {
            return JXPathUtils.getXPathNodes(this.rootContext, jxPathContext, path);
        }
        catch (Exception ex) {
            this.msgCenter.info((Object)("Error evaluating path(" + path + ")"), new Object[0]);
            return null;
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getValue(Object o) {
        return o;
    }
}

