/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.integration;

import repast.simphony.integration.DataTypeHandler;
import simphony.util.messages.MessageCenter;

public enum ArrayDataTypeHandler {
    INT(DataTypeHandler.INT.getTypeName()){

        @Override
        public ArrayHandler getHandler(int rows, int cols) {
            return new IntHandler(rows, cols, null);
        }

        @Override
        public ArrayHandler getHandler(int rows, int cols, Object data) {
            return new IntHandler(rows, cols, data);
        }
    }
    ,
    STRING(DataTypeHandler.STRING.getTypeName()){

        @Override
        public ArrayHandler getHandler(int rows, int cols) {
            return new StringHandler(rows, cols, null);
        }

        @Override
        public ArrayHandler getHandler(int rows, int cols, Object data) {
            return new StringHandler(rows, cols, data);
        }
    }
    ,
    DOUBLE(DataTypeHandler.DOUBLE.getTypeName()){

        @Override
        public ArrayHandler getHandler(int rows, int cols) {
            return new DoubleHandler(rows, cols, null);
        }

        @Override
        public ArrayHandler getHandler(int rows, int cols, Object data) {
            return new DoubleHandler(rows, cols, data);
        }
    };

    private static MessageCenter msgCenter;
    private String typeName;

    static {
        msgCenter = MessageCenter.getMessageCenter(ArrayDataTypeHandler.class);
    }

    private ArrayDataTypeHandler(String description) {
        this.typeName = description;
    }

    public static ArrayDataTypeHandler getDataType(String typeName) {
        ArrayDataTypeHandler[] arrayDataTypeHandlerArray = ArrayDataTypeHandler.values();
        int n = arrayDataTypeHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayDataTypeHandler handler = arrayDataTypeHandlerArray[n2];
            if (handler.typeName.equalsIgnoreCase(typeName)) {
                return handler;
            }
            ++n2;
        }
        return null;
    }

    public abstract ArrayHandler getHandler(int var1, int var2);

    public abstract ArrayHandler getHandler(int var1, int var2, Object var3);

    /* synthetic */ ArrayDataTypeHandler(String string, int n, String string2, ArrayDataTypeHandler arrayDataTypeHandler) {
        this(string2);
    }

    public static interface ArrayHandler {
        public void setValue(int var1, int var2, String var3);

        public Object getValue();

        public String getValueString(int var1, int var2);

        public int getRowCount();
    }

    class DoubleHandler
    implements ArrayHandler {
        double[] array1d;
        double[][] array2d;

        public DoubleHandler(int rows, int cols, Object data) {
            if (cols == 1) {
                this.array1d = data == null ? new double[rows] : (double[])data;
            } else {
                this.array2d = data == null ? new double[rows][cols] : (double[][])data;
            }
        }

        @Override
        public void setValue(int row, int col, String value) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                this.array1d[row] = Double.parseDouble(value);
            } else {
                this.array2d[row][col] = Double.parseDouble(value);
            }
        }

        @Override
        public Object getValue() {
            if (this.array1d != null) {
                return this.array1d;
            }
            return this.array2d;
        }

        @Override
        public String getValueString(int row, int col) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                return Double.toString(this.array1d[row]);
            }
            return Double.toString(this.array2d[row][col]);
        }

        @Override
        public int getRowCount() {
            if (this.array1d != null) {
                return this.array1d.length;
            }
            return this.array2d.length;
        }
    }

    class IntHandler
    implements ArrayHandler {
        int[] array1d;
        int[][] array2d;

        public IntHandler(int rows, int cols, Object data) {
            if (cols == 1) {
                this.array1d = data == null ? new int[rows] : (int[])data;
            } else {
                this.array2d = data == null ? new int[rows][cols] : (int[][])data;
            }
        }

        @Override
        public void setValue(int row, int col, String value) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                this.array1d[row] = Integer.parseInt(value);
            } else {
                this.array2d[row][col] = Integer.parseInt(value);
            }
        }

        @Override
        public Object getValue() {
            if (this.array1d != null) {
                return this.array1d;
            }
            return this.array2d;
        }

        @Override
        public String getValueString(int row, int col) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                return Integer.toString(this.array1d[row]);
            }
            return Integer.toString(this.array2d[row][col]);
        }

        @Override
        public int getRowCount() {
            if (this.array1d != null) {
                return this.array1d.length;
            }
            return this.array2d.length;
        }
    }

    class StringHandler
    implements ArrayHandler {
        String[] array1d;
        String[][] array2d;

        public StringHandler(int rows, int cols, Object data) {
            if (cols == 1) {
                this.array1d = data == null ? new String[rows] : (String[])data;
            } else {
                this.array2d = data == null ? new String[rows][cols] : (String[][])data;
            }
        }

        @Override
        public void setValue(int row, int col, String value) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                this.array1d[row] = value;
            } else {
                this.array2d[row][col] = value;
            }
        }

        @Override
        public Object getValue() {
            if (this.array1d != null) {
                return this.array1d;
            }
            return this.array2d;
        }

        @Override
        public String getValueString(int row, int col) {
            if (this.array1d != null) {
                if (col != 0) {
                    msgCenter.warn((Object)("Warning: in a 1-dimensional handler received a 2-dimensional index (" + row + "," + col + "). Ignoring the column."), new Object[0]);
                }
                return this.array1d[row];
            }
            return this.array2d[row][col];
        }

        @Override
        public int getRowCount() {
            if (this.array1d != null) {
                return this.array1d.length;
            }
            return this.array2d.length;
        }
    }
}

