/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.groovy.math;

import java.util.ArrayList;
import javax.measure.unit.Unit;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseMatrix;
import org.jscience.physics.amount.Amount;

public class MatrixOperations {
    public static DenseMatrix createDenseMatrix(ArrayList sourceArrayList) {
        Amount[][] sourceArray = new Amount[sourceArrayList.size()][((ArrayList)sourceArrayList.get(0)).size()];
        int rowIndex = 0;
        while (rowIndex < sourceArrayList.size()) {
            ArrayList row = (ArrayList)sourceArrayList.get(rowIndex);
            int columnIndex = 0;
            while (columnIndex < row.size()) {
                Amount element;
                sourceArray[rowIndex][columnIndex] = element = (Amount)row.get(columnIndex);
                ++columnIndex;
            }
            ++rowIndex;
        }
        return DenseMatrix.valueOf((Field[][])sourceArray);
    }

    public static DenseMatrix createDenseMatrix(Amount[][] sourceArray) {
        return DenseMatrix.valueOf((Field[][])sourceArray);
    }

    public static SparseMatrix createSparseMatrix(ArrayList sourceArrayList, Amount zero) {
        return SparseMatrix.valueOf((Matrix)MatrixOperations.createDenseMatrix(sourceArrayList), (Field)zero);
    }

    public static SparseMatrix createSparseMatrix(Amount[][] sourceArray, Amount zero) {
        return SparseMatrix.valueOf((Matrix)MatrixOperations.createDenseMatrix(sourceArray), (Field)zero);
    }

    public static Matrix addition(Matrix m1, Matrix m2) {
        return m1.plus(m2);
    }

    public static Matrix subtraction(Matrix m1, Matrix m2) {
        return m1.minus(m2);
    }

    public static Matrix multiplication(Matrix m1, Matrix m2) {
        return m1.times(m2);
    }

    public static Matrix multiplication(Matrix m1, Amount amount) {
        return m1.times((Field)amount);
    }

    public static Matrix division(Matrix m1, Amount amount) {
        return m1.times((Field)amount.inverse());
    }

    public static Matrix multiplication(Amount amount, Matrix m1) {
        return m1.times((Field)amount);
    }

    public static Matrix multiplication(Matrix m1, Number number) {
        return m1.times((Field)Amount.valueOf((double)number.doubleValue(), (Unit)Amount.ZERO.getUnit()));
    }

    public static Matrix division(Matrix m1, Number number) {
        return m1.times((Field)Amount.valueOf((double)number.doubleValue(), (Unit)Amount.ZERO.getUnit()).inverse());
    }

    public static Matrix multiplication(Number number, Matrix m1) {
        return m1.times((Field)Amount.valueOf((double)number.doubleValue(), (Unit)Amount.ZERO.getUnit()));
    }

    public static Matrix exponentiation(Matrix m1, int exponent) {
        return m1.pow(exponent);
    }
}

