/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collections;
import java.util.Map;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotools.referencing.operation.projection.TransverseMercator;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchIdentifierException;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import simphony.util.messages.MessageCenter;

public class UTMFinder {
    private static final MessageCenter center = MessageCenter.getMessageCenter(UTMFinder.class);
    private static DefaultCoordinateOperationFactory cFactory = new DefaultCoordinateOperationFactory();
    private static CoordinateReferenceSystem wgs84 = DefaultGeographicCRS.WGS84;

    public static short determineZone(double lat, double lon) {
        if (lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Lon value must be between -180 and 180");
        }
        double val = (lon += 180.0) / 6.0;
        if (val == 0.0 || val == (double)((int)val) && val % 2.0 == 1.0) {
            val += 1.0;
        }
        short zn = (short)Math.ceil(val);
        return lat < 0.0 ? -zn : zn;
    }

    public static CoordinateReferenceSystem getUTMFor(Geometry geom, CoordinateReferenceSystem crs) {
        try {
            if (!crs.equals(wgs84)) {
                CoordinateOperation op = cFactory.createOperation(crs, wgs84);
                geom = JTS.transform((Geometry)geom, (MathTransform)op.getMathTransform());
            }
        }
        catch (FactoryException e) {
            center.error((Object)"Error during crs conversion", (Throwable)e, new Object[0]);
        }
        catch (TransformException e) {
            center.error((Object)"Error during geometry transform", (Throwable)e, new Object[0]);
        }
        return UTMFinder.getUTMfor(geom.getCoordinate().y, geom.getCoordinate().x);
    }

    public static CoordinateReferenceSystem getUTMfor(double lat, double lon) {
        return UTMFinder.getUTMfor(UTMFinder.determineZone(lat, lon));
    }

    public static CoordinateReferenceSystem getUTMfor(short zone) {
        DefaultGeographicCRS geoCRS = DefaultGeographicCRS.WGS84;
        MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
        DefaultCartesianCS cartCS = DefaultCartesianCS.GENERIC_2D;
        ParameterValueGroup parameters = null;
        try {
            parameters = mtFactory.getDefaultParameters("Transverse_Mercator");
            parameters.parameter("central_meridian").setValue(6 * Math.abs(zone) - 183);
            parameters.parameter("latitude_of_origin").setValue(0.0);
            parameters.parameter("scale_factor").setValue(0.9996);
            double northing = zone > 0 ? 0.0 : 1.0E7;
            parameters.parameter("false_easting").setValue(500000.0);
            parameters.parameter("false_northing").setValue(northing);
        }
        catch (NoSuchIdentifierException e) {
            center.error((Object)("Projection parameters not found creating UTM zone: " + zone), (Throwable)e, new Object[0]);
            return null;
        }
        Map<String, String> properties = Collections.singletonMap("name", "WGS 84 / UTM Zone " + zone + (zone > 0 ? "N" : "S"));
        Conversion conv = null;
        ProjectedCRS projCRS = null;
        TransverseMercator.Provider method = new TransverseMercator.Provider();
        try {
            conv = cFactory.createDefiningConversion(properties, (OperationMethod)method, parameters);
            projCRS = crsFactory.createProjectedCRS(properties, (GeographicCRS)geoCRS, conv, (CartesianCS)cartCS);
        }
        catch (FactoryException e) {
            center.error((Object)("Error creating Projected CRS for UTM zone: " + zone), (Throwable)e, new Object[0]);
        }
        return projCRS;
    }
}

