/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import repast.simphony.space.gis.FeatureAgentFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.Layer;
import repast.simphony.space.gis.ShapefileFeatureAgentFactory;
import simphony.util.messages.MessageCenter;

public class ShapefileWriter {
    private static MessageCenter msg = MessageCenter.getMessageCenter(ShapefileWriter.class);
    private Geography geography;

    public ShapefileWriter(Geography geography) {
        this.geography = geography;
    }

    public void write(String layerName, URL url) {
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        Layer layer = this.geography.getLayer(layerName);
        ShapefileFeatureAgentFactory fac = FeatureAgentFactoryFinder.getInstance().getShapefileFeatureAgentFactory(layer.getAgentType(), layer.getGeomType(), this.geography.getCRS());
        for (Object obj : layer.getAgentSet()) {
            features.add(fac.getFeature(obj, this.geography));
        }
        SimpleFeatureType type = fac.getFeatureType();
        try {
            this.write(url, features, type);
        }
        catch (IOException ex) {
            msg.error((Object)"Error writing geography to shapefile", (Throwable)ex, new Object[0]);
        }
    }

    private void write(URL url, List<SimpleFeature> features, SimpleFeatureType type) throws IOException {
        ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("url", url);
        params.put("create spatial index", Boolean.TRUE);
        ShapefileDataStore store = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
        store.forceSchemaCRS(this.geography.getCRS());
        store.createSchema(type);
        String featureName = store.getTypeNames()[0];
        DefaultTransaction transaction = new DefaultTransaction("create");
        SimpleFeatureStore fs = (SimpleFeatureStore)store.getFeatureSource(featureName);
        fs.setTransaction((Transaction)transaction);
        ListFeatureCollection collection = new ListFeatureCollection(type, features);
        try {
            try {
                fs.addFeatures((FeatureCollection)collection);
                transaction.commit();
            }
            catch (Exception problem) {
                problem.printStackTrace();
                transaction.rollback();
                transaction.close();
            }
        }
        finally {
            transaction.close();
        }
    }
}

