/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import repast.simphony.random.RandomHelper;
import repast.simphony.space.gis.GISAdder;
import repast.simphony.space.gis.Geography;
import simphony.util.messages.MessageCenter;

public class RandomGISAdder<T>
implements GISAdder<T> {
    Geometry geometry;
    WKTReader reader;
    Envelope bb;

    public RandomGISAdder(Geometry geom) {
        this.geometry = geom;
        this.bb = this.geometry.getEnvelopeInternal();
        this.reader = new WKTReader();
    }

    public void add(Geography<T> destination, T object) {
        double x = RandomHelper.getUniform().nextDoubleFromTo(this.bb.getMinX(), this.bb.getMaxX());
        double y = RandomHelper.getUniform().nextDoubleFromTo(this.bb.getMinY(), this.bb.getMaxY());
        try {
            Geometry geom = this.reader.read("POINT(" + x + " " + y + ")");
            while (!this.geometry.contains(geom)) {
                x = RandomHelper.getUniform().nextDoubleFromTo(this.bb.getMinX(), this.bb.getMaxX());
                y = RandomHelper.getUniform().nextDoubleFromTo(this.bb.getMinY(), this.bb.getMaxY());
                geom = this.reader.read("POINT(" + x + " " + y + ")");
            }
            destination.move(object, geom);
        }
        catch (ParseException e) {
            MessageCenter.getMessageCenter(this.getClass()).warn((Object)"Unable to create Geometry from wkt", (Throwable)e, new Object[0]);
        }
    }
}

