/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.space.gis;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.quadtree.Quadtree;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.commons.collections15.Predicate;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.GeodeticCalculator;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.query.space.projection.Within;
import repast.simphony.space.gis.GISAdder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.Layer;
import repast.simphony.space.projection.DefaultProjection;
import repast.simphony.space.projection.Projection;
import repast.simphony.space.projection.ProjectionEvent;
import repast.simphony.space.projection.ProjectionPredicate;
import repast.simphony.util.collections.FilteredIterator;
import simphony.util.messages.MessageCenter;

public class DefaultGeography<T>
extends DefaultProjection<T>
implements Geography<T> {
    private static final MessageCenter msg = MessageCenter.getMessageCenter(DefaultGeography.class);
    private static GeometryFactory fac = new GeometryFactory();
    private Map<T, GeomData> geomMap = new HashMap<T, GeomData>();
    private SpatialIndex index = new Quadtree();
    private CoordinateReferenceSystem crs;
    private Map<String, Layer<T>> layerMap = new HashMap<String, Layer<T>>();
    protected GISAdder<T> adder;
    private Set<T> addedObjects = new HashSet<T>();
    private GeodeticCalculator calc;
    MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);

    public DefaultGeography(String name) {
        super(name);
        this.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    }

    public DefaultGeography(String name, String crsCode) {
        super(name);
        try {
            this.setCRS(CRS.decode((String)crsCode));
        }
        catch (NoSuchAuthorityCodeException e) {
            msg.error((Object)"Error creating default geography", (Throwable)e, new Object[0]);
        }
        catch (FactoryException e) {
            msg.error((Object)"Error creating default geography", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public Collection<String> getLayerNames() {
        return Collections.unmodifiableCollection(this.layerMap.keySet());
    }

    protected void add(T object) {
        this.addedObjects.add(object);
        if (!this.layerMap.containsKey(this.layerNameFor(object))) {
            this.createLayer(object);
        }
    }

    private String layerNameFor(T object) {
        return String.valueOf(object.getClass().getName()) + ".FeatureType";
    }

    private Layer<T> createLayer(T object) {
        String name = this.layerNameFor(object);
        Layer layer = new Layer(name);
        layer.setAgentType(object.getClass());
        this.layerMap.put(name, layer);
        return layer;
    }

    @Override
    public void move(T object, Geometry geom) {
        Layer<T> layer = this.layerMap.get(this.layerNameFor(object));
        if (layer == null) {
            layer = this.createLayer(object);
        }
        if (geom == null) {
            layer.getAgentSet().remove(object);
            GeomData data = this.geomMap.remove(object);
            if (data != null) {
                this.index.remove(data.envelope, object);
            }
            return;
        }
        if (layer.getGeomType() == null) {
            layer.setGeomType(geom.getClass());
        } else if (!layer.getGeomType().isAssignableFrom(geom.getClass())) {
            msg.error((Object)"Error moving object in geography", (Throwable)new IllegalArgumentException("Geometry type must match for layer"), new Object[0]);
        }
        GeomData geomData = this.geomMap.get(object);
        if (geomData != null) {
            this.index.remove(geomData.envelope, object);
        } else {
            geomData = new GeomData();
            this.geomMap.put(object, geomData);
        }
        geom.geometryChanged();
        geomData.envelope = new Envelope(geom.getEnvelopeInternal());
        geomData.geom = geom;
        this.index.insert(geomData.envelope, object);
        this.addedObjects.remove(object);
        if (!layer.getAgentSet().contains(object)) {
            layer.getAgentSet().add(object);
        }
        this.fireProjectionEvent(new ProjectionEvent((Projection)this, object, ProjectionEvent.Type.OBJECT_MOVED));
    }

    @Override
    public Layer getLayer(Class clazz) {
        String layerName = String.valueOf(clazz.getName()) + ".FeatureType";
        return this.layerMap.get(layerName);
    }

    @Override
    public Layer getLayer(String name) {
        return this.layerMap.get(name);
    }

    @Override
    public Geometry getGeometry(Object object) {
        GeomData gd = this.geomMap.get(object);
        return gd != null ? gd.geom : null;
    }

    @Override
    public Iterable<T> getObjectsWithin(Envelope envelope) {
        WithinItemVisitor visitor = new WithinItemVisitor(envelope);
        this.index.query(envelope, visitor);
        return visitor;
    }

    @Override
    public Iterable<T> queryInexact(Envelope envelope) {
        return this.index.query(envelope);
    }

    @Override
    public <X> Iterable<X> getObjectsWithin(Envelope envelope, Class<X> type) {
        WithinItemVisitor visitor = new WithinItemVisitor(envelope);
        this.index.query(envelope, visitor);
        return new FilteredIterator(visitor.iterator(), (Predicate)new TypePredicate(type));
    }

    @Override
    public <X> Iterable<X> queryInexact(Envelope envelope, Class<X> type) {
        return new FilteredIterator(this.index.query(envelope).iterator(), (Predicate)new TypePredicate(type));
    }

    @Override
    public Iterable<T> getAllObjects() {
        return this.geomMap.keySet();
    }

    @Override
    public int size() {
        return this.geomMap.size();
    }

    @Override
    public void setCRS(String crsCode) {
        try {
            this.setCRS(CRS.decode((String)crsCode));
        }
        catch (NoSuchAuthorityCodeException e) {
            msg.error((Object)"Error setting CRS", (Throwable)e, new Object[0]);
        }
        catch (FactoryException e) {
            msg.error((Object)"Error setting CRS", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setCRS(CoordinateReferenceSystem crs) {
        this.calc = new GeodeticCalculator(crs);
        if (this.crs == null) {
            this.crs = crs;
            return;
        }
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)crs);
            for (Map.Entry<T, GeomData> entry : this.geomMap.entrySet()) {
                GeomData gd = entry.getValue();
                T key = entry.getKey();
                this.index.remove(gd.envelope, key);
                gd.geom = JTS.transform((Geometry)gd.geom, (MathTransform)transform);
                Envelope envelope = new Envelope(gd.geom.getEnvelopeInternal());
                this.index.insert(envelope, key);
                gd.envelope = envelope;
            }
            this.crs = crs;
        }
        catch (FactoryException e) {
            msg.error((Object)"Error setting CRS", (Throwable)e, new Object[0]);
        }
        catch (MismatchedDimensionException e) {
            msg.error((Object)"Error setting CRS", (Throwable)e, new Object[0]);
        }
        catch (TransformException e) {
            msg.error((Object)"Error setting CRS", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public Geometry moveByVector(T object, double distance, double angleInRadians) {
        Geometry geom = this.getGeometry(object);
        if (geom == null) {
            msg.error((Object)"Error moving object by vector", (Throwable)new IllegalArgumentException(String.valueOf(object.toString()) + " does not have an assigned geometry.  Initialize the geometry " + "using Geography.move(object, geom)"), new Object[0]);
            return null;
        }
        if (angleInRadians > Math.PI * 2 || angleInRadians < 0.0) {
            throw new IllegalArgumentException("Direction cannot be > PI (360) or less than 0");
        }
        double angleInDegrees = Math.toDegrees(angleInRadians);
        angleInDegrees %= 360.0;
        angleInDegrees = 360.0 - angleInDegrees;
        angleInDegrees += 90.0;
        if ((angleInDegrees %= 360.0) > 180.0) {
            angleInDegrees -= 360.0;
        }
        Coordinate coord = geom.getCoordinate();
        try {
            if (!this.crs.equals(DefaultGeographicCRS.WGS84)) {
                MathTransform crsTrans = CRS.findMathTransform((CoordinateReferenceSystem)this.crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                Coordinate tmp = new Coordinate();
                JTS.transform((Coordinate)coord, (Coordinate)tmp, (MathTransform)crsTrans);
                this.calc.setStartingGeographicPoint(tmp.x, tmp.y);
            } else {
                this.calc.setStartingGeographicPoint(coord.x, coord.y);
            }
            this.calc.setDirection(angleInDegrees, distance);
            Point2D p = this.calc.getDestinationGeographicPoint();
            if (!this.crs.equals(DefaultGeographicCRS.WGS84)) {
                MathTransform crsTrans = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.crs);
                JTS.transform((Coordinate)new Coordinate(p.getX(), p.getY()), (Coordinate)coord, (MathTransform)crsTrans);
            }
            AffineTransform transform = AffineTransform.getTranslateInstance(p.getX() - coord.x, p.getY() - coord.y);
            MathTransform mt = this.mtFactory.createAffineTransform((Matrix)new GeneralMatrix(transform));
            geom = JTS.transform((Geometry)geom, (MathTransform)mt);
        }
        catch (Exception ex) {
            msg.error((Object)"Error moving object by vector", (Throwable)ex, new Object[0]);
        }
        this.move(object, geom);
        return geom;
    }

    @Override
    public Geometry moveByVector(T object, double distance, Unit unit, double angleInRadians) {
        if (!unit.isCompatible(SI.METER)) {
            msg.error((Object)"Error moving object by vector", (Throwable)new IllegalArgumentException("Unable to convert: " + unit + " into distance measure"), new Object[0]);
        }
        return this.moveByVector(object, unit.getConverterTo(SI.METER).convert(distance), angleInRadians);
    }

    @Override
    public Geometry moveByDisplacement(T object, double lonShift, double latShift) {
        Geometry geom = this.getGeometry(object);
        if (geom == null) {
            msg.error((Object)"Error moving object by displacement", (Throwable)new IllegalArgumentException(String.valueOf(object.toString()) + " does not have an assigned geometry.  Initialize the geometry " + "using Geography.move(object, geom)"), new Object[0]);
            return null;
        }
        AffineTransform transform = AffineTransform.getTranslateInstance(lonShift, latShift);
        try {
            MathTransform mt = this.mtFactory.createAffineTransform((Matrix)new GeneralMatrix(transform));
            geom = JTS.transform((Geometry)geom, (MathTransform)mt);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to transform geometry", ex);
        }
        this.move(object, geom);
        return geom;
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    protected void remove(T object) {
        GeomData gd = this.geomMap.get(object);
        if (gd != null) {
            this.index.remove(gd.envelope, object);
            this.geomMap.remove(object);
            Layer<T> layer = this.layerMap.get(this.layerNameFor(object));
            layer.getAgentSet().remove(object);
        } else {
            this.addedObjects.remove(object);
        }
        this.fireProjectionEvent(new ProjectionEvent((Projection)this, object, ProjectionEvent.Type.OBJECT_REMOVED));
    }

    @Override
    public GISAdder<T> getAdder() {
        return this.adder;
    }

    @Override
    public void setAdder(GISAdder<T> adder) {
        this.adder = adder;
    }

    @Override
    public Unit getUnits(int axis) {
        return this.crs.getCoordinateSystem().getAxis(axis).getUnit();
    }

    public boolean evaluate(ProjectionPredicate predicate) {
        if (predicate instanceof Within) {
            return this.evaluateWithin((Within)predicate);
        }
        return false;
    }

    public boolean evaluateWithin(Within within) {
        Geometry geom1 = this.getGeometry(within.getObj1());
        Geometry geom2 = this.getGeometry(within.getObj2());
        try {
            return JTS.orthodromicDistance((Coordinate)geom1.getCentroid().getCoordinate(), (Coordinate)geom2.getCentroid().getCoordinate(), (CoordinateReferenceSystem)this.getCRS()) <= within.getDistance();
        }
        catch (TransformException e) {
            msg.error((Object)"Error calculating orthodromic distance", (Throwable)e, new Object[0]);
            return false;
        }
    }

    static class GeomData {
        Envelope envelope;
        Geometry geom;

        GeomData() {
        }
    }

    private static class TypePredicate
    implements Predicate<Object> {
        private Class<?> type;

        public TypePredicate(Class<?> type) {
            this.type = type;
        }

        public boolean evaluate(Object x) {
            return x.getClass().equals(this.type);
        }
    }

    private class WithinItemVisitor<T>
    implements ItemVisitor,
    Iterable {
        List<T> items = new ArrayList<T>();
        Geometry env;

        public WithinItemVisitor(Envelope env) {
            this.env = fac.toGeometry(env);
        }

        public void visitItem(Object o) {
            Geometry geo = ((GeomData)((DefaultGeography)DefaultGeography.this).geomMap.get((Object)o)).geom;
            if (geo.within(this.env)) {
                this.items.add(o);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.iterator();
        }
    }
}

