/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.collections15.Predicate;
import repast.simphony.query.space.gis.AbstractGeometryQuery;
import repast.simphony.space.gis.Geography;

public class WithinQuery<T>
extends AbstractGeometryQuery<T> {
    public WithinQuery(Geography<T> geography, T sourceObject) {
        super(geography, sourceObject);
    }

    public WithinQuery(Geography<T> geography, Geometry geom) {
        super(geography, geom);
    }

    @Override
    protected Predicate<T> createPredicate() {
        if (this.sourceObject == null) {
            return new NoSourceWithinPredicate();
        }
        return new WithinPredicate();
    }

    private class NoSourceWithinPredicate<T>
    implements Predicate<T> {
        private NoSourceWithinPredicate() {
        }

        public boolean evaluate(T o) {
            Geometry other = WithinQuery.this.geography.getGeometry(o);
            return other != null && WithinQuery.this.geom.within(other);
        }
    }

    private class WithinPredicate<T>
    implements Predicate<T> {
        private WithinPredicate() {
        }

        public boolean evaluate(T o) {
            if (!WithinQuery.this.sourceObject.equals(o)) {
                Geometry other = WithinQuery.this.geography.getGeometry(o);
                return other != null && WithinQuery.this.geom.within(other);
            }
            return false;
        }
    }
}

