/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import org.apache.commons.collections15.Predicate;
import repast.simphony.query.space.gis.AbstractGeometryQuery;
import repast.simphony.space.gis.Geography;

public class IntersectsQuery<T>
extends AbstractGeometryQuery<T> {
    public IntersectsQuery(Geography<T> geography, T sourceObject) {
        super(geography, sourceObject);
    }

    public IntersectsQuery(Geography<T> geography, Geometry geom) {
        super(geography, geom);
    }

    @Override
    protected Predicate<T> createPredicate() {
        if (this.sourceObject != null) {
            return new IntersectsPredicate();
        }
        return new NoSourceIntersectsPredicate();
    }

    private class IntersectsPredicate<T>
    implements Predicate<T> {
        private IntersectsPredicate() {
        }

        public boolean evaluate(T o) {
            if (!o.equals(IntersectsQuery.this.sourceObject)) {
                Geometry other = IntersectsQuery.this.geography.getGeometry(o);
                return other != null && other.intersects(IntersectsQuery.this.geom);
            }
            return false;
        }
    }

    private class NoSourceIntersectsPredicate<T>
    implements Predicate<T> {
        private NoSourceIntersectsPredicate() {
        }

        public boolean evaluate(T o) {
            Geometry other = IntersectsQuery.this.geography.getGeometry(o);
            return other != null && other.intersects(IntersectsQuery.this.geom);
        }
    }
}

