/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.query.space.gis;

import com.vividsolutions.jts.geom.Geometry;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.query.Query;
import repast.simphony.query.space.gis.IntersectsQuery;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.UTMFinder;
import simphony.util.messages.MessageCenter;

public class GeographyWithin<T>
implements Query<T> {
    private static DefaultCoordinateOperationFactory cFactory = new DefaultCoordinateOperationFactory();
    private static final MessageCenter center = MessageCenter.getMessageCenter(GeographyWithin.class);
    private IntersectsQuery query;
    private Object sourceObject;

    public GeographyWithin(Geography geography, double distance, Object sourceObject) {
        this.sourceObject = sourceObject;
        this.init(geography, distance, geography.getGeometry(sourceObject));
    }

    public GeographyWithin(Geography geography, double distance, Unit units, Object sourceObject) {
        this.sourceObject = sourceObject;
        this.init(geography, units.getConverterTo(SI.METER).convert(distance), geography.getGeometry(sourceObject));
    }

    public GeographyWithin(Geography geography, double distance, Unit units, Geometry location) {
        this.init(geography, units.getConverterTo(SI.METER).convert(distance), location);
    }

    public GeographyWithin(Geography geography, double distance, Geometry location) {
        this.init(geography, distance, location);
    }

    private void init(Geography geography, double distance, Geometry geom) {
        boolean convert = !geography.getUnits(0).equals((Object)SI.METER);
        CoordinateReferenceSystem utm = null;
        Geometry buffer = null;
        CoordinateReferenceSystem crs = geography.getCRS();
        Geometry tempGeom = geom;
        try {
            if (convert) {
                utm = UTMFinder.getUTMFor(geom, crs);
                tempGeom = JTS.transform((Geometry)geom, (MathTransform)cFactory.createOperation(crs, utm).getMathTransform());
            }
            buffer = tempGeom.buffer(distance);
            if (convert) {
                buffer = JTS.transform((Geometry)buffer, (MathTransform)cFactory.createOperation(utm, crs).getMathTransform());
            }
        }
        catch (FactoryException e) {
            center.error((Object)"Error during crs transform", (Throwable)e, new Object[0]);
        }
        catch (TransformException e) {
            center.error((Object)"Error during crs transform", (Throwable)e, new Object[0]);
        }
        this.query = new IntersectsQuery(geography, buffer);
        this.query.sourceObject = this.sourceObject;
        this.query.predicate = this.query.createPredicate();
    }

    public Iterable<T> query() {
        return this.query.query();
    }

    public Iterable<T> query(Iterable<T> set) {
        return this.query.query(set);
    }
}

