/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.xml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import junit.framework.TestCase;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.context.space.graph.NetworkFactoryFinder;
import repast.simphony.gis.engine.GeographyProjectionController;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.xml.TestAgent;
import repast.simphony.xml.XMLSerializer;

public class GeographyToXmlTests
extends TestCase {
    private Context<TestAgent> context;
    private XMLSerializer xmlSer;

    public void setUp() {
        new GeographyProjectionController();
        this.context = new DefaultContext((Object)"foo", (Object)"bar");
        int i = 0;
        while (i < 4) {
            TestAgent agent = new TestAgent(i, "john the " + i);
            this.context.add((Object)agent);
            ++i;
        }
        GeographyFactoryFinder.createGeographyFactory(null).createGeography("geog", this.context, new GeographyParameters());
        Network network = NetworkFactoryFinder.createNetworkFactory(null).createNetwork("network", this.context, true);
        this.xmlSer = new XMLSerializer();
    }

    public void testGeography() {
        HashMap<Integer, TestAgent> agentMap = new HashMap<Integer, TestAgent>();
        HashMap<Integer, RepastEdge> edgeMap = new HashMap<Integer, RepastEdge>();
        Geography geog = (Geography)this.context.getProjection("geog");
        Network net = (Network)this.context.getProjection("network");
        GeometryFactory factory = new GeometryFactory();
        for (TestAgent agent : this.context) {
            agentMap.put(agent.getIntVal(), agent);
            Coordinate[] coords = new Coordinate[5];
            int i = 0;
            while (i < 5) {
                Coordinate coord;
                coords[i] = coord = new Coordinate(Math.random(), Math.random());
                ++i;
            }
            geog.move(agent, (Geometry)factory.createLineString(coords));
        }
        int i = 0;
        while (i < 10) {
            TestAgent source = (TestAgent)this.context.getRandomObject();
            TestAgent target = (TestAgent)this.context.getRandomObject();
            RepastEdge edge = net.addEdge((Object)source, (Object)target);
            edge.setWeight((double)i);
            edgeMap.put((int)edge.getWeight(), edge);
            Coordinate[] coords = new Coordinate[5];
            int j = 0;
            while (j < 5) {
                Coordinate coord;
                coords[j] = coord = new Coordinate(Math.random(), Math.random());
                ++j;
            }
            geog.move(edge, (Geometry)factory.createLineString(coords));
            ++i;
        }
        StringWriter string = new StringWriter();
        this.xmlSer.toXML(this.context, (Writer)string);
        this.context = (Context)this.xmlSer.fromXML(string.toString());
        Geography newGeog = (Geography)this.context.getProjection("geog");
        GeographyToXmlTests.assertEquals((int)geog.size(), (int)newGeog.size());
        GeographyToXmlTests.assertEquals((String)geog.getCRS().toWKT(), (String)newGeog.getCRS().toWKT());
        GeographyToXmlTests.assertEquals(geog.getAdder().getClass(), newGeog.getAdder().getClass());
        for (Object obj : newGeog.getLayer(TestAgent.class).getAgentSet()) {
            TestAgent agent = (TestAgent)agentMap.get(((TestAgent)obj).getIntVal());
            this.geomEquals(geog.getGeometry(agent), newGeog.getGeometry(obj));
        }
        for (Object obj : newGeog.getLayer(RepastEdge.class).getAgentSet()) {
            RepastEdge edge = (RepastEdge)edgeMap.get((int)((RepastEdge)obj).getWeight());
            this.geomEquals(geog.getGeometry(edge), newGeog.getGeometry(obj));
        }
    }

    private void geomEquals(Geometry one, Geometry two) {
        Coordinate[] c1 = one.getCoordinates();
        Coordinate[] c2 = two.getCoordinates();
        GeographyToXmlTests.assertEquals((int)c1.length, (int)c2.length);
        int i = 0;
        while (i < c1.length) {
            GeographyToXmlTests.assertEquals((double)c1[i].x, (double)c2[i].x, (double)1.0E-8);
            GeographyToXmlTests.assertEquals((double)c1[i].y, (double)c2[i].y, (double)1.0E-8);
            ++i;
        }
    }
}

