/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.io;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.ShapefileLoader;

public class LoaderTest {
    Geography geography;
    Context context;
    GeographyParameters<Object> params;

    @Before
    public void setUp() throws MalformedURLException {
        this.context = new DefaultContext();
        this.params = new GeographyParameters();
        this.geography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("Geography", this.context, this.params);
    }

    @Test
    public void testNext() throws IOException, FactoryException, TransformException {
        File file = new File("./sampleData/states.shp");
        ShapefileDataStore store = new ShapefileDataStore(file.toURL());
        ContentFeatureCollection collection = store.getFeatureSource().getFeatures();
        MathTransform trans = CRS.findMathTransform((CoordinateReferenceSystem)store.getFeatureSource().getSchema().getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.geography.getCRS(), (boolean)true);
        SimpleFeatureIterator fIterator = collection.features();
        ShapefileLoader<TestAgent> loader = new ShapefileLoader<TestAgent>(TestAgent.class, file.toURL(), this.geography, this.context);
        while (loader.hasNext()) {
            TestAgent agent = loader.next();
            SimpleFeature feature = (SimpleFeature)fIterator.next();
            Assert.assertEquals((double)((Double)feature.getAttribute("AREA")), (double)agent.getArea(), (double)0.0);
            Assert.assertEquals((Object)feature.getAttribute("STATE_NAME"), (Object)agent.getStateName());
            Assert.assertEquals((Object)feature.getAttribute("POP1999"), (Object)agent.getPop1999());
            Assert.assertEquals((Object)JTS.transform((Geometry)((Geometry)feature.getDefaultGeometry()), (MathTransform)trans).toText(), (Object)this.geography.getGeometry(agent).toText());
        }
        fIterator.close();
    }

    @Test
    public void testNextWithCArgs() throws IOException, FactoryException, TransformException {
        File file = new File("./sampleData/states.shp");
        ShapefileDataStore store = new ShapefileDataStore(file.toURL());
        ContentFeatureCollection collection = store.getFeatureSource().getFeatures();
        MathTransform trans = CRS.findMathTransform((CoordinateReferenceSystem)store.getFeatureSource().getSchema().getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.geography.getCRS(), (boolean)true);
        SimpleFeatureIterator fIterator = collection.features();
        ShapefileLoader<TestAgent> loader = new ShapefileLoader<TestAgent>(TestAgent.class, file.toURL(), this.geography, this.context);
        int i = 0;
        while (loader.hasNext()) {
            TestAgent agent = loader.nextWithArgs(new Integer(i), String.valueOf(i));
            SimpleFeature feature = (SimpleFeature)fIterator.next();
            Assert.assertEquals((double)((Double)feature.getAttribute("AREA")), (double)agent.getArea(), (double)0.0);
            Assert.assertEquals((Object)feature.getAttribute("STATE_NAME"), (Object)agent.getStateName());
            Assert.assertEquals((Object)feature.getAttribute("POP1999"), (Object)agent.getPop1999());
            Assert.assertEquals((Object)JTS.transform((Geometry)((Geometry)feature.getDefaultGeometry()), (MathTransform)trans).toText(), (Object)this.geography.getGeometry(agent).toText());
            Assert.assertEquals((long)i, (long)agent.id);
            Assert.assertEquals((Object)String.valueOf(i), (Object)agent.strID);
            ++i;
        }
        fIterator.close();
    }

    @Test
    public void testNextWithObj() throws IOException, FactoryException, TransformException {
        File file = new File("./sampleData/states.shp");
        ShapefileDataStore store = new ShapefileDataStore(file.toURL());
        ContentFeatureCollection collection = store.getFeatureSource().getFeatures();
        MathTransform trans = CRS.findMathTransform((CoordinateReferenceSystem)store.getFeatureSource().getSchema().getCoordinateReferenceSystem(), (CoordinateReferenceSystem)this.geography.getCRS(), (boolean)true);
        SimpleFeatureIterator fIterator = collection.features();
        ShapefileLoader<TestAgent> loader = new ShapefileLoader<TestAgent>(TestAgent.class, file.toURL(), this.geography, this.context);
        int i = 0;
        while (loader.hasNext()) {
            TestAgent agent = new TestAgent(new Integer(i), String.valueOf(i));
            loader.next(agent);
            SimpleFeature feature = (SimpleFeature)fIterator.next();
            Assert.assertEquals((double)((Double)feature.getAttribute("AREA")), (double)agent.getArea(), (double)0.0);
            Assert.assertEquals((Object)feature.getAttribute("STATE_NAME"), (Object)agent.getStateName());
            Assert.assertEquals((Object)feature.getAttribute("POP1999"), (Object)agent.getPop1999());
            Assert.assertEquals((Object)JTS.transform((Geometry)((Geometry)feature.getDefaultGeometry()), (MathTransform)trans).toText(), (Object)this.geography.getGeometry(agent).toText());
            Assert.assertEquals((long)i, (long)agent.id);
            Assert.assertEquals((Object)String.valueOf(i), (Object)agent.strID);
            ++i;
        }
        fIterator.close();
    }

    public static class TestAgent {
        private double area;
        private Long pop1999;
        private String stateName;
        private int id;
        private String strID;

        public TestAgent() {
        }

        public TestAgent(int id, String strID) {
            this.id = id;
            this.strID = strID;
        }

        public double getArea() {
            return this.area;
        }

        public void setArea(double area) {
            this.area = area;
        }

        public Long getPop1999() {
            return this.pop1999;
        }

        public void setPop1999(Long pop1999) {
            this.pop1999 = pop1999;
        }

        public String getStateName() {
            return this.stateName;
        }

        public void setStateName(String stateName) {
            this.stateName = stateName;
        }
    }
}

