/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.gis.freezedry;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import repast.simphony.context.Context;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.freezedry.freezedryers.proj.GridProjectionDryer2;
import repast.simphony.freezedry.freezedryers.proj.ProjectionDryer;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import simphony.util.messages.MessageCenter;

public class GeographyProjectionDryer
extends ProjectionDryer<Geography<?>> {
    public static final String AGENT_LOCATIONS_KEY = "agentLocations";
    public static final String CRS_KEY = "crs";
    private static final MessageCenter LOG = MessageCenter.getMessageCenter(GridProjectionDryer2.class);

    protected void addProperties(Context<?> context, Geography<?> geog, Map<String, Object> map) {
        HashMap agentLocs = new HashMap();
        for (Object o : geog.getAllObjects()) {
            Geometry geometry = geog.getGeometry(o);
            agentLocs.put(o, (Geometry)geometry.getClass().cast(geometry));
        }
        map.put(AGENT_LOCATIONS_KEY, agentLocs);
        CoordinateReferenceSystem crs = geog.getCRS();
        if (!crs.equals(DefaultGeographicCRS.WGS84)) {
            map.put(CRS_KEY, crs.toWKT());
        }
        map.put("name", geog.getName());
    }

    protected void loadProperties(Context<?> context, Geography<?> proj, Map<String, Object> properties) {
        super.loadProperties(context, proj, properties);
        this.loadAgents(context, proj, properties);
    }

    protected void loadAgents(Context<?> context, Geography proj, Map<String, Object> properties) {
        HashMap locations = (HashMap)properties.get(AGENT_LOCATIONS_KEY);
        if (locations == null) {
            LOG.info((Object)("Could not find any locations for context '" + context + "'."), new Object[0]);
        }
        for (Object o : locations.keySet()) {
            if (locations.get(o) instanceof Geometry) {
                Geometry loc = (Geometry)locations.get(o);
                proj.move(o, loc);
                continue;
            }
            LOG.warn((Object)("Object '" + o + "'s location did not resolve to a geometry, the object will not be placed in the geography."), new Object[0]);
        }
    }

    protected Geography<?> instantiate(Context<?> context, Map<String, Object> properties) {
        String crs = (String)properties.get(CRS_KEY);
        String name = (String)properties.get("name");
        GeographyParameters geoParams = new GeographyParameters();
        Geography<?> geography = GeographyFactoryFinder.createGeographyFactory(null).createGeography(name, context, geoParams);
        if (crs != null) {
            geography.setCRS(crs);
        }
        return geography;
    }

    public boolean handles(Class<?> type) {
        return Geography.class.isAssignableFrom(type);
    }
}

