/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.essentials;

import java.util.HashSet;
import java.util.List;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import junit.framework.TestCase;
import org.jscience.physics.amount.Amount;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.graph.NetworkFileFormat;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.schedule.DefaultScheduleFactory;
import repast.simphony.engine.schedule.IAction;
import repast.simphony.engine.schedule.ISchedulableAction;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.essentials.RepastEssentials;
import repast.simphony.essentials.SimpleDataObject;
import repast.simphony.space.Dimensions;
import repast.simphony.space.continuous.ContinuousSpace;
import repast.simphony.space.continuous.DefaultContinuousSpace;
import repast.simphony.space.continuous.StrictBorders;
import repast.simphony.space.graph.DirectedJungNetwork;
import repast.simphony.space.graph.Network;
import repast.simphony.space.graph.RepastEdge;
import repast.simphony.space.grid.BouncyBorders;
import repast.simphony.space.grid.DefaultGrid;
import repast.simphony.space.grid.Grid;
import repast.simphony.space.grid.GridDimensions;
import repast.simphony.space.grid.GridPoint;
import repast.simphony.space.grid.MultiOccupancyCellAccessor;
import repast.simphony.space.grid.SingleOccupancyCellAccessor;
import repast.simphony.space.projection.Projection;
import repast.simphony.valueLayer.ContinuousValueLayer;
import repast.simphony.valueLayer.GridValueLayer;
import repast.simphony.valueLayer.ValueLayer;

public class RETest
extends TestCase {
    private Context root;

    public void setUp() {
        this.root = new DefaultContext((Object)"root");
        this.root.addProjection((Projection)new DirectedJungNetwork("rootNet"));
        this.root.addSubContext((Context)new DefaultContext((Object)"child1"));
        DefaultContext child2 = new DefaultContext((Object)"child2");
        child2.addProjection((Projection)new DirectedJungNetwork("net1"));
        this.root.addSubContext((Context)child2);
        child2.addSubContext((Context)new DefaultContext((Object)"grandchild2"));
        DefaultContext grandchild1 = new DefaultContext((Object)"grandchild1");
        grandchild1.addProjection((Projection)new DirectedJungNetwork("net2"));
        child2.addSubContext((Context)grandchild1);
        this.root.addProjection((Projection)new DefaultGrid("rootGrid", new int[0]));
        this.root.addProjection((Projection)new DefaultContinuousSpace("rootSpace", new double[0]));
        RunState.init();
        RunState.getInstance().setMasterContext(this.root);
        DefaultScheduleFactory fac = new DefaultScheduleFactory();
        RunEnvironment.init((ISchedule)fac.createSchedule(), null, null, (boolean)false);
    }

    public void testFindContext() {
        Context context = RepastEssentials.FindContext("root");
        RETest.assertEquals((Object)this.root, (Object)context);
        context = RepastEssentials.FindContext("root/child2");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2"), (Object)context);
        context = RepastEssentials.FindContext("root/child2/grandchild1");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2").getSubContext((Object)"grandchild1"), (Object)context);
        context = RepastEssentials.FindContext("child2/grandchild2");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2").getSubContext((Object)"grandchild2"), (Object)context);
        context = RepastEssentials.FindContext("root/foo/grandchild1");
        RETest.assertNull((Object)context);
    }

    public void testGetObjs() {
        int i = 0;
        while (i < 5) {
            this.root.add((Object)i);
            ++i;
        }
        this.root.add((Object)"hello");
        this.root.add((Object)"goodbye");
        HashSet<String> set = new HashSet<String>();
        set.add("hello");
        set.add("goodbye");
        for (Object obj : RepastEssentials.GetObjects("root", "java.lang.String")) {
            RETest.assertTrue((boolean)set.remove(obj));
        }
        RETest.assertEquals((int)0, (int)set.size());
        set.add("hello");
        set.add("goodbye");
        for (Object obj : RepastEssentials.GetRandomObjects("root", "java.lang.String", 1L)) {
            RETest.assertTrue((boolean)set.remove(obj));
        }
        RETest.assertEquals((int)1, (int)set.size());
        set.clear();
        set.add("hello");
        set.add("goodbye");
        for (Object obj : RepastEssentials.GetRandomObjects("root", "java.lang.String", 10L)) {
            RETest.assertTrue((boolean)set.remove(obj));
        }
        RETest.assertEquals((int)0, (int)set.size());
    }

    public void testFindParentContext() {
        Context context = RepastEssentials.FindParentContext("root/child2");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root, (Object)context);
        context = RepastEssentials.FindParentContext("root/child2/grandchild1");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2"), (Object)context);
        context = RepastEssentials.FindParentContext("child2/grandchild2");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2"), (Object)context);
        context = RepastEssentials.FindParentContext("root/foo/grandchild1");
        RETest.assertNull((Object)context);
    }

    public void testFindProjection() {
        Projection proj = RepastEssentials.FindProjection("/root/rootNet");
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getProjection("rootNet"), (Object)proj);
        RETest.assertEquals((Object)proj, (Object)RepastEssentials.FindProjection("rootNet"));
        proj = RepastEssentials.FindProjection("child2/grandchild1/net2");
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2").getSubContext((Object)"grandchild1").getProjection("net2"), (Object)proj);
        proj = RepastEssentials.FindProjection("root/child2/grandchild1/net2");
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child2").getSubContext((Object)"grandchild1").getProjection("net2"), (Object)proj);
        proj = RepastEssentials.FindProjection("child2/net10");
        RETest.assertNull((Object)proj);
    }

    public void testFindNetwork() {
        Network net = RepastEssentials.FindNetwork("/root/rootNet");
        RETest.assertNotNull((Object)net);
        RETest.assertEquals((Object)this.root.getProjection("rootNet"), (Object)net);
        RETest.assertEquals((Object)net, (Object)RepastEssentials.FindNetwork("rootNet"));
    }

    public void testFindGrid() {
        Grid grid = RepastEssentials.FindGrid("/root/rootGrid");
        RETest.assertNotNull((Object)grid);
        RETest.assertEquals((Object)this.root.getProjection("rootGrid"), (Object)grid);
        RETest.assertEquals((Object)grid, (Object)RepastEssentials.FindGrid("rootGrid"));
    }

    public void testFindContinuousSpace() {
        ContinuousSpace space = RepastEssentials.FindContinuousSpace("/root/rootSpace");
        RETest.assertNotNull((Object)space);
        RETest.assertEquals((Object)this.root.getProjection("rootSpace"), (Object)space);
        RETest.assertEquals((Object)space, (Object)RepastEssentials.FindContinuousSpace("rootSpace"));
    }

    public void testCreateContext() {
        Context context = RepastEssentials.CreateContext("/root/child1", "baby wee");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getSubContext((Object)"baby wee"), (Object)context);
    }

    public void testRemoveContext() {
        Context context = RepastEssentials.CreateContext("/root/child1", "baby wee");
        RETest.assertNotNull((Object)context);
        Context babyWee = this.root.getSubContext((Object)"child1").getSubContext((Object)"baby wee");
        RETest.assertEquals((Object)babyWee, (Object)context);
        context = RepastEssentials.RemoveContext("child1/baby wee");
        RETest.assertNotNull((Object)context);
        RETest.assertEquals((Object)babyWee, (Object)context);
        RETest.assertNull((Object)this.root.getSubContext((Object)"child1").getSubContext((Object)"baby wee"));
    }

    public void testCreateProjection() {
        Projection proj = RepastEssentials.CreateProjection("/root/child1", "grid", "Grid", true, "BouncyBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("grid"), (Object)proj);
        Grid grid = (Grid)proj;
        GridDimensions dims = grid.getDimensions();
        RETest.assertEquals((int)10, (int)dims.getWidth());
        RETest.assertEquals((int)20, (int)dims.getHeight());
        RETest.assertEquals((int)30, (int)dims.getDepth());
        RETest.assertTrue((boolean)(grid.getGridPointTranslator() instanceof BouncyBorders));
        RETest.assertTrue((boolean)(grid.getCellAccessor() instanceof MultiOccupancyCellAccessor));
        proj = RepastEssentials.CreateProjection("/root/child1", "grid", "Grid", false, "StrictBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("grid"), (Object)proj);
        grid = (Grid)proj;
        dims = grid.getDimensions();
        RETest.assertEquals((int)10, (int)dims.getWidth());
        RETest.assertEquals((int)20, (int)dims.getHeight());
        RETest.assertEquals((int)30, (int)dims.getDepth());
        RETest.assertTrue((boolean)(grid.getGridPointTranslator() instanceof repast.simphony.space.grid.StrictBorders));
        RETest.assertTrue((boolean)(grid.getCellAccessor() instanceof SingleOccupancyCellAccessor));
        proj = RepastEssentials.CreateProjection("/root/child1", "net", "Graph", true);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("net"), (Object)proj);
        Network net = (Network)proj;
        RETest.assertTrue((boolean)net.isDirected());
        proj = RepastEssentials.CreateProjection("/root/child1", "net2", "Graph", false, "StrictBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("net2"), (Object)proj);
        net = (Network)proj;
        RETest.assertTrue((!net.isDirected() ? 1 : 0) != 0);
        proj = RepastEssentials.CreateProjection("/root/child1", "cs", "Continuous", false, "StrictBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("cs"), (Object)proj);
        ContinuousSpace space = (ContinuousSpace)proj;
        Dimensions spaceDims = space.getDimensions();
        RETest.assertEquals((Object)10.0, (Object)spaceDims.getWidth());
        RETest.assertEquals((Object)20.0, (Object)spaceDims.getHeight());
        RETest.assertEquals((Object)30.0, (Object)spaceDims.getDepth());
        RETest.assertTrue((boolean)(space.getPointTranslator() instanceof StrictBorders));
    }

    public void testRemoveProjection() {
        Projection proj = RepastEssentials.CreateProjection("/root/child1", "grid", "Grid", true, "BouncyBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1").getProjection("grid"), (Object)proj);
        Projection removed = RepastEssentials.RemoveProjection("/child1/grid");
        RETest.assertEquals((Object)proj, (Object)removed);
        RETest.assertNull((Object)this.root.getSubContext((Object)"child1").getProjection("grid"));
    }

    public void testCreateAgent() {
        Object obj = RepastEssentials.CreateAgent("/root/child2", "java.lang.Object");
        RETest.assertEquals((int)1, (int)this.root.getSubContext((Object)"child2").size());
        RETest.assertEquals((Object)obj, (Object)this.root.getSubContext((Object)"child2").getRandomObject());
    }

    public void testEdges() {
        Object source = new Object();
        Object target = new Object();
        this.root.add(source);
        this.root.add(target);
        Network net = (Network)RepastEssentials.CreateProjection("/root", "net", "Graph", true);
        RepastEdge<?> edge = RepastEssentials.CreateEdge("/root/net", source, target);
        RETest.assertEquals((Object)source, (Object)edge.getSource());
        RETest.assertEquals((Object)target, (Object)edge.getTarget());
        RETest.assertEquals((int)1, (int)net.numEdges());
        RETest.assertEquals(edge, net.getEdges().iterator().next());
        net.removeEdge(edge);
        edge = RepastEssentials.CreateEdge("/root/net", source, target, 2.0);
        RETest.assertEquals((Object)source, (Object)edge.getSource());
        RETest.assertEquals((Object)target, (Object)edge.getTarget());
        RETest.assertEquals((Object)2.0, (Object)edge.getWeight());
        RETest.assertEquals((int)1, (int)net.numEdges());
        RETest.assertEquals(edge, net.getEdges().iterator().next());
        RepastEdge foundEdge = RepastEssentials.FindEdge("/root/net", source, target);
        RETest.assertEquals(edge, (Object)foundEdge);
        RETest.assertEquals((Object)2.0, (Object)RepastEssentials.GetEdgeWeight("/root/net", source, target));
        foundEdge = RepastEssentials.SetEdgeWeight("/root/net", source, target, 1.5);
        RETest.assertEquals(edge, (Object)foundEdge);
        RETest.assertEquals((Object)1.5, (Object)foundEdge.getWeight());
        foundEdge = RepastEssentials.RemoveEdge("/root/net", source, target);
        RETest.assertEquals(edge, (Object)foundEdge);
        RETest.assertEquals((int)0, (int)net.numEdges());
        RETest.assertNull((Object)RepastEssentials.FindEdge("/root/net", source, target));
    }

    public void testValueLayers() {
        GridValueLayer layer = RepastEssentials.CreateGridValueLayer("/root/child1", "gvl", 10, 20);
        RETest.assertNotNull((Object)layer);
        RETest.assertEquals((Object)10.0, (Object)layer.getDimensions().getDimension(0));
        RETest.assertEquals((Object)20.0, (Object)layer.getDimensions().getDimension(1));
        ValueLayer oLayer = RepastEssentials.FindValueLayer("/root/child1/gvl");
        RETest.assertEquals((Object)oLayer, (Object)layer);
        ContinuousValueLayer clayer = RepastEssentials.CreateContinuousValueLayer("root", "cvl", 10.5, 20.3);
        RETest.assertNotNull((Object)clayer);
        RETest.assertEquals((Object)10.5, (Object)clayer.getDimensions().getDimension(0));
        RETest.assertEquals((Object)20.3, (Object)clayer.getDimensions().getDimension(1));
        oLayer = RepastEssentials.FindValueLayer("root/cvl");
        RETest.assertEquals((Object)oLayer, (Object)clayer);
        layer = new GridValueLayer("gvl2", false, new int[]{1, 2});
        RepastEssentials.AddValueLayer("root/child1", (ValueLayer)layer);
        RETest.assertEquals((Object)layer, (Object)RepastEssentials.FindValueLayer("root/child1/gvl2"));
    }

    public void testNetLoader() {
        Network net = RepastEssentials.CreateNetwork("/root", "Loaded Net", true, "java.lang.Object", "./repast.simphony.core/test/repast/simphony/graph/double_matrix.dl", NetworkFileFormat.DL);
        RETest.assertNotNull((Object)net);
        RETest.assertEquals((int)19, (int)net.getDegree());
    }

    public void testAgents() {
        Object obj = new Object();
        Context context = RepastEssentials.AddAgentToContext("/root/child1", obj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1"), (Object)context);
        RETest.assertEquals((int)1, (int)context.size());
        RETest.assertEquals((Object)obj, context.iterator().next());
        context = RepastEssentials.RemoveAgentFromContext("/root/child1", obj);
        RETest.assertEquals((Object)this.root.getSubContext((Object)"child1"), (Object)context);
        RETest.assertEquals((int)0, (int)context.size());
        this.root.getSubContext((Object)"child1").add(obj);
        this.root.getSubContext((Object)"child2").add(obj);
        this.root.add(new Object());
        context = RepastEssentials.RemoveAgentFromModel(obj);
        RETest.assertEquals((Object)this.root, (Object)context);
        RETest.assertEquals((int)0, (int)this.root.getSubContext((Object)"child1").size());
        RETest.assertEquals((int)0, (int)this.root.getSubContext((Object)"child2").size());
        RETest.assertEquals((int)1, (int)this.root.size());
    }

    public void testMove() {
        Projection proj = RepastEssentials.CreateProjection("/root/child1", "grid", "Grid", true, "BouncyBorders", 10, 20, 30);
        RETest.assertNotNull((Object)proj);
        Context context = this.root.getSubContext((Object)"child1");
        RETest.assertEquals((Object)context.getProjection("grid"), (Object)proj);
        Object obj = new Object();
        context.add(obj);
        boolean result = RepastEssentials.MoveAgent("/root/child1/grid", obj, 4, 3, 1);
        RETest.assertTrue((boolean)result);
        Grid grid = (Grid)proj;
        GridPoint pt = grid.getLocation(obj);
        RETest.assertEquals((int)4, (int)pt.getX());
        RETest.assertEquals((int)3, (int)pt.getY());
        RETest.assertEquals((int)1, (int)pt.getZ());
    }

    public void testTickCount() {
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        Amount unitAmount = Amount.valueOf((long)2L, (Unit)SI.SECOND);
        schedule.setTimeUnits(unitAmount);
        schedule.schedule(ScheduleParameters.createOneTime((double)2.5), new IAction(){

            public void execute() {
            }
        });
        schedule.execute();
        RETest.assertEquals((Object)2.5, (Object)RepastEssentials.GetTickCount());
        RETest.assertEquals((Object)unitAmount.times(2.5), (Object)RepastEssentials.GetTickCountInTimeUnits());
    }

    public void testActions() {
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        TestObject obj = new TestObject();
        RepastEssentials.ScheduleAction((Object)obj, "run", 2);
        schedule.execute();
        RETest.assertEquals((Object)1.0, (Object)schedule.getTickCount());
        RETest.assertEquals((Object)3.0, (Object)obj.tick);
        obj.tick = 0.0;
        RepastEssentials.ScheduleAction((Object)obj, 2.0, "run", new Object[0]);
        schedule.execute();
        RETest.assertEquals((Object)2.0, (Object)obj.tick);
        ISchedulableAction action = RepastEssentials.ScheduleAction((Object)obj, 3.0, 1.0, "run", 2);
        int i = 0;
        while (i < 5) {
            schedule.execute();
            RETest.assertEquals((Object)((double)i + 3.0 + 2.0), (Object)obj.tick);
            ++i;
        }
        RepastEssentials.CancelAction(action);
        obj.tick = -1.0;
        i = 0;
        while (i < 10) {
            schedule.execute();
            RETest.assertEquals((Object)-1.0, (Object)obj.tick);
            ++i;
        }
    }

    public void testNetMethods() {
        Object one = new Object();
        Object two = new Object();
        Object three = new Object();
        this.root.add(one);
        this.root.add(two);
        this.root.add(three);
        RepastEdge<?> oneToTwo = RepastEssentials.CreateEdge("/root/rootNet", one, two);
        RepastEdge<?> twoToThree = RepastEssentials.CreateEdge("/root/rootNet", two, three);
        RepastEdge<?> oneToThree = RepastEssentials.CreateEdge("/root/rootNet", one, three);
        List<RepastEdge> list = RepastEssentials.GetPredecessors("/root/rootNet", one);
        RETest.assertEquals((int)0, (int)list.size());
        list = RepastEssentials.GetSuccessors("/root/rootNet", one);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(two));
        RETest.assertTrue((boolean)list.contains(three));
        list = RepastEssentials.GetPredecessors("/root/rootNet", three);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(two));
        RETest.assertTrue((boolean)list.contains(one));
        list = RepastEssentials.GetAdjacent("/root/rootNet", two);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(three));
        RETest.assertTrue((boolean)list.contains(one));
        list = RepastEssentials.GetInEdges("/root/rootNet", three);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(twoToThree));
        RETest.assertTrue((boolean)list.contains(oneToThree));
        list = RepastEssentials.GetOutEdges("/root/rootNet", one);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(oneToThree));
        RETest.assertTrue((boolean)list.contains(oneToTwo));
        list = RepastEssentials.GetEdges("/root/rootNet", two);
        RETest.assertEquals((int)2, (int)list.size());
        RETest.assertTrue((boolean)list.contains(twoToThree));
        RETest.assertTrue((boolean)list.contains(oneToTwo));
    }

    public void testFileReadWrite() {
        SimpleDataObject obj = new SimpleDataObject();
        RepastEssentials.ReadExternalFile(obj, "./test/repast/simphony/essentials/SimpleDef.xml", "./test/repast/simphony/essentials/simple_data_read.txt");
        RETest.assertEquals((String)"Nick Collier", (String)obj.getName());
        RETest.assertEquals((Object)23.22343, (Object)obj.getValue());
        obj.setName("Sam Jones");
        obj.setValue(3.2);
        RepastEssentials.WriteExternalFile(obj, "./test/repast/simphony/essentials/SimpleDef.xml", "./test/repast/simphony/essentials/simple_data_write.txt");
        obj.setName("");
        obj.setValue(0.0);
        RepastEssentials.ReadExternalFile(obj, "./test/repast/simphony/essentials/SimpleDef.xml", "./test/repast/simphony/essentials/simple_data_write.txt");
        RETest.assertEquals((String)"Sam Jones", (String)obj.getName());
        RETest.assertEquals((Object)3.2, (Object)obj.getValue());
    }

    public void testExecute() {
        DataObject obj = new DataObject();
        obj.setSinInput(2.0);
        obj.setTanInput(0.5);
        RepastEssentials.WriteExternalFile(obj, "./test/repast/simphony/essentials/TrigOutDef.xml", "./input.txt");
        RepastEssentials.ExecuteProgram("", "./trig.exe");
        RepastEssentials.ReadExternalFile(obj, "./test/repast/simphony/essentials/TrigInDef.xml", "./output.txt");
        RETest.assertEquals((double)Math.sin(obj.getSinInput()), (double)obj.getSinVal(), (double)1.0E-5);
        RETest.assertEquals((double)Math.tan(obj.getTanInput()), (double)obj.getTanVal(), (double)1.0E-5);
    }

    public class DataObject {
        private double sinInput;
        private double tanInput;
        private double sinVal;
        private double tanVal;

        public double getSinInput() {
            return this.sinInput;
        }

        public void setSinInput(double sinInput) {
            this.sinInput = sinInput;
        }

        public double getSinVal() {
            return this.sinVal;
        }

        public void setSinVal(double sinVal) {
            this.sinVal = sinVal;
        }

        public double getTanInput() {
            return this.tanInput;
        }

        public void setTanInput(double tanInput) {
            this.tanInput = tanInput;
        }

        public double getTanVal() {
            return this.tanVal;
        }

        public void setTanVal(double tanVal) {
            this.tanVal = tanVal;
        }
    }

    class TestObject {
        double tick;
        String name = "foo";

        TestObject() {
        }

        public void run() {
            this.tick = RunEnvironment.getInstance().getCurrentSchedule().getTickCount();
        }

        public void run(int val) {
            this.tick = RunEnvironment.getInstance().getCurrentSchedule().getTickCount() + (double)val;
        }

        public double getTick() {
            return this.tick;
        }

        public void setTick(double tick) {
            this.tick = tick;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

