/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import repast.simphony.batch.ssh.BaseOutputNamesFinder;
import repast.simphony.batch.ssh.BatchParameterChunker;
import repast.simphony.batch.ssh.BatchParameterChunkerException;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.DefaultOutputPatternCreator;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.ModelArchiveConfiguratorException;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.SessionException;
import repast.simphony.batch.ssh.StatusException;

public class SessionsDriver {
    private static Logger logger = Logger.getLogger(SessionsDriver.class);
    private Configuration config;

    public SessionsDriver(String propsFile) throws IOException {
        this.config = new Configuration(propsFile);
        SSHSessionFactory.init(this.config.getSSHKeyDir());
    }

    public void run() {
        try {
            long start = System.currentTimeMillis();
            BatchParameterChunker chunker = new BatchParameterChunker(this.config);
            chunker.run();
            String directory = "simphony_model_" + System.currentTimeMillis();
            long time = System.currentTimeMillis();
            for (Session session : this.config.sessions()) {
                session.initModelArchive(this.config, directory);
            }
            String string = String.format("Initialization Time: %.4f", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f / 60.0f));
            logger.info((Object)string);
            time = System.currentTimeMillis();
            for (Session session : this.config.sessions()) {
                session.runModel();
            }
            this.pollForDone(directory);
            String string2 = String.format("Run Time: %.4f", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f / 60.0f));
            logger.info((Object)string2);
            time = System.currentTimeMillis();
            this.getRemoteRunStatus();
            this.copyRemoteRunStatus();
            this.writeRemoteRunStatus();
            this.concatenateOutput(directory);
            String string3 = String.format("Get Output Time: %.4f", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f / 60.0f));
            logger.info((Object)string3);
            long l = System.currentTimeMillis() - start;
            String string4 = String.format("Finished. Elapsed Time: %.4f", Float.valueOf((float)l / 1000.0f / 60.0f));
            logger.info((Object)string4);
        }
        catch (StatusException ex) {
            this.logError(ex.getMessage(), ex);
        }
        catch (SessionException ex) {
            this.logError(ex.getMessage(), ex);
        }
        catch (BatchParameterChunkerException ex) {
            this.logError("Error while processing batch parameters for distribution", ex);
        }
        catch (ModelArchiveConfiguratorException ex) {
            this.logError("Error while preparing zip file for distributions", ex);
        }
    }

    private void logError(String msg, Throwable t) {
        Throwable cause = t.getCause() == null ? t : t.getCause();
        logger.error((Object)msg, cause);
        System.err.println(msg);
    }

    private void writeRemoteRunStatus() throws SessionException {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(String.valueOf(this.config.getOutputDir()) + "/" + "status_output.properties"));
                for (Session session : this.config.sessions()) {
                    String prefix = String.valueOf(session.getHost()) + "." + session.getUser() + ".";
                    int i = 1;
                    while (i <= session.getInstances()) {
                        writer.append(prefix);
                        writer.append(String.valueOf(i));
                        writer.append(" = ");
                        writer.append(session.getStatus(i).toString());
                        writer.newLine();
                        ++i;
                    }
                }
            }
            catch (IOException iOException) {
                throw new SessionException("Error while writing remote status file to " + this.config.getOutputDir(), iOException);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new SessionException("Error while closing remote status file.", ex);
                }
            }
        }
    }

    private void copyRemoteRunStatus() throws StatusException {
        for (Session session : this.config.sessions()) {
            session.copyCompletionStatus(this.config.getOutputDir());
        }
    }

    private void getRemoteRunStatus() throws StatusException {
        for (Session session : this.config.sessions()) {
            session.retrieveRunCompletionStatus();
        }
    }

    private void concatenateOutput(String remoteDir) throws StatusException, SessionException {
        ArrayList<BaseOutputNamesFinder.FinderOutput> foundFS = new ArrayList<BaseOutputNamesFinder.FinderOutput>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile zipFile = new ZipFile(this.config.getModelArchive());){
                BaseOutputNamesFinder finder = new BaseOutputNamesFinder();
                Enumeration<? extends ZipEntry> iter = zipFile.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry entry = iter.nextElement();
                    if (!entry.getName().startsWith("scenario.rs/repast.simphony.action.file_sink")) continue;
                    foundFS.add(finder.find(zipFile.getInputStream(entry)));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XMLStreamException ex) {
            throw new SessionException("Error while finding default output file names", ex);
        }
        ArrayList<OutputPattern> patterns = new ArrayList<OutputPattern>();
        for (BaseOutputNamesFinder.FinderOutput fo : foundFS) {
            DefaultOutputPatternCreator creator = new DefaultOutputPatternCreator(fo.getFileName(), fo.hasTimestamp());
            patterns.add(creator.getParamMapPattern());
            patterns.add(creator.getFileSinkOutputPattern());
        }
        patterns.addAll(this.config.getOutputPatterns());
        HashMap<String, MatchedFiles> matches = new HashMap<String, MatchedFiles>();
        for (Session session : this.config.sessions()) {
            for (MatchedFiles match : session.findOutput(patterns)) {
                String output = match.getPattern().getPath();
                MatchedFiles files = (MatchedFiles)matches.get(output);
                if (files == null) {
                    matches.put(output, match);
                    continue;
                }
                files.addAllFiles(match.getFiles());
            }
        }
        try {
            logger.info((Object)("Aggregating output into " + this.config.getOutputDir()));
            for (MatchedFiles matchedFiles : matches.values()) {
                matchedFiles.aggregateOutput(this.config.getOutputDir());
            }
        }
        catch (IOException iOException) {
            throw new SessionException("Error while aggregating output", iOException);
        }
    }

    private void pollForDone(String remoteDir) throws SessionException {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ExecutorService executor = null;
        try {
            executor = Executors.newFixedThreadPool(this.config.getRemoteCount());
            for (Session session : this.config.sessions()) {
                Callable<Void> poller = session.createDonePoller((long)(this.config.getPollFrequency() * 1000.0f));
                futures.add(executor.submit(poller));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception ex) {
                    String msg = String.format("Error while polling a remote for finish", new Object[0]);
                    throw new SessionException(msg, ex);
                }
            }
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Properties props = new Properties();
            File in = new File("./config/SSH.MessageCenter.log4j.properties");
            props.load(new FileInputStream(in));
            PropertyConfigurator.configure((Properties)props);
            try {
                new SessionsDriver(args[0]).run();
            }
            catch (IOException ex) {
                logger.error((Object)"Error reading ssh driver configuration file", (Throwable)ex);
            }
        }
        catch (IOException ex) {
            logger.error((Object)"Error reading log configuration properties file", (Throwable)ex);
        }
    }
}

