/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import repast.simphony.batch.ssh.LocalSession;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.Session;

public class SessionBuilder {
    private Map<Integer, RemoteSession> remoteMap = new HashMap<Integer, RemoteSession>();
    private LocalSession localSession = null;

    private RemoteSession getRemote(int id) {
        RemoteSession session = this.remoteMap.get(id);
        if (session == null) {
            session = new RemoteSession();
            this.remoteMap.put(id, session);
        }
        return session;
    }

    public void addHost(int id, String host) throws IOException {
        RemoteSession session = this.getRemote(id);
        if (session.host != null) {
            throw new IOException(String.format("Duplicate host property for remote %d", id));
        }
        session.host = host;
    }

    public void addKeyFile(int id, String keyFile) {
        RemoteSession session = this.getRemote(id);
        session.keyFile = keyFile;
    }

    public void addInstancesToRemote(int id, int instances) throws IOException {
        RemoteSession session = this.getRemote(id);
        if (session.instances != 0) {
            throw new IOException(String.format("Duplicate instances property for remote %d", id));
        }
        session.instances = instances;
    }

    public void addInstancesToLocal(int id, int instances) throws IOException {
        if (this.localSession == null) {
            this.localSession = new LocalSession();
        }
        if (this.localSession.instances != 0) {
            throw new IOException(String.format("Duplicate instances property for local %d", id));
        }
        this.localSession.instances = instances;
    }

    public void addWorkingDirectory(int id, String workingDirectory) throws IOException {
        if (this.localSession == null) {
            this.localSession = new LocalSession();
        }
        if (this.localSession.workingDir != null) {
            throw new IOException(String.format("Duplicate working directory property for local %d", id));
        }
        String wd = workingDirectory.contains("~/") ? workingDirectory.replace("~", System.getProperty("user.home")) : workingDirectory;
        this.localSession.workingDir = wd.replace("\\", "/");
    }

    public void addUser(int id, String user) throws IOException {
        RemoteSession session = this.getRemote(id);
        if (session.user != null) {
            throw new IOException(String.format("Duplicate user property for remote %d", id));
        }
        session.user = user;
    }

    public List<? extends Session> getSessions() throws IOException {
        for (Integer id : this.remoteMap.keySet()) {
            RemoteSession session = this.remoteMap.get(id);
            if (session.host != null && session.user != null && session.instances != 0) continue;
            throw new IOException(String.format("Remote %d is missing a required property", id));
        }
        if (this.localSession != null && (this.localSession.workingDir == null || this.localSession.instances == 0)) {
            throw new IOException("local session is missing a required property");
        }
        ArrayList<RemoteSession> sessions = new ArrayList<RemoteSession>(this.remoteMap.values());
        if (this.localSession != null) {
            sessions.add((RemoteSession)((Object)this.localSession));
        }
        return sessions;
    }
}

