/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.HashMap;
import java.util.Map;
import repast.simphony.batch.ssh.ConsoleUserInfo;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSession;

public class SSHSessionFactory {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(SSHSessionFactory.class);
    private static SSHSessionFactory instance;
    private UserInfo userInfo;
    private String sshKeyDir;
    private Map<String, byte[]> passphrases = new HashMap<String, byte[]>();

    static {
        JSch.setLogger((Logger)new Logger(){

            public boolean isEnabled(int priority) {
                return true;
            }

            public void log(int priority, String msg) {
                if (priority == 0) {
                    logger.debug((Object)msg);
                } else if (priority == 3) {
                    logger.error((Object)msg);
                } else if (priority == 4) {
                    logger.fatal((Object)msg);
                } else if (priority == 1) {
                    logger.info((Object)msg);
                } else if (priority == 2) {
                    logger.warn((Object)msg);
                }
            }
        });
    }

    public static void init(String sshKeyDir) {
        instance = new SSHSessionFactory(sshKeyDir);
    }

    public static SSHSessionFactory getInstance() {
        if (instance == null) {
            throw new RuntimeException("SSHSessionFactory must be initialized before use.");
        }
        return instance;
    }

    private SSHSessionFactory(String sshKeyDir) {
        this.sshKeyDir = sshKeyDir;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public SSHSession create(RemoteSession remote) throws JSchException {
        JSch jsch = new JSch();
        byte[] passphrase = this.passphrases.get(remote.getKeyFile());
        if (passphrase != null) {
            jsch.addIdentity(String.valueOf(this.sshKeyDir) + "/" + remote.getKeyFile(), passphrase);
        } else {
            jsch.addIdentity(String.valueOf(this.sshKeyDir) + "/" + remote.getKeyFile());
        }
        jsch.setKnownHosts(String.valueOf(this.sshKeyDir) + "/known_hosts");
        Session session = jsch.getSession(remote.getUser(), remote.getHost());
        session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
        UserInfo uInfo = null;
        uInfo = this.userInfo == null ? new ConsoleUserInfo() : this.userInfo;
        session.setUserInfo(uInfo);
        session.connect();
        if (passphrase == null) {
            passphrase = uInfo.getPassphrase().getBytes();
            this.passphrases.put(remote.getKeyFile(), passphrase);
        }
        return new SSHSession(session);
    }
}

