/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import repast.simphony.batch.LoggingOutputStream;

public class SSHSession {
    private static Logger logger = Logger.getLogger(SSHSession.class);
    private Session session;

    public SSHSession(Session session) {
        this.session = session;
    }

    public void executeBackgroundCommand(String cmd) throws JSchException {
        Channel channel = null;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setPty(false);
            ((ChannelExec)channel).setCommand(String.valueOf(cmd) + " > /dev/null 2>&1 &");
            channel.setInputStream(null);
            channel.connect();
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    private void listRemoteDirectory(ChannelSftp sftp, String remoteDir, List<String> files, boolean recurse) throws SftpException {
        Vector entries = sftp.ls(remoteDir);
        ArrayList<String> subs = new ArrayList<String>();
        for (ChannelSftp.LsEntry entry : entries) {
            String filename = entry.getFilename();
            if (filename.equals(".") || filename.equals("..")) continue;
            if (recurse && entry.getAttrs().isDir()) {
                subs.add(String.valueOf(remoteDir) + "/" + filename);
            }
            files.add(String.valueOf(remoteDir) + "/" + filename);
        }
        for (String sub : subs) {
            this.listRemoteDirectory(sftp, sub, files, true);
        }
    }

    public List<String> listRemoteDirectory(String remoteDir) throws JSchException, SftpException {
        return this.listRemoteDirectory(remoteDir, false);
    }

    public List<String> listRemoteDirectory(String remoteDir, boolean recurse) throws JSchException, SftpException {
        ArrayList<String> out = new ArrayList<String>();
        ChannelSftp sftp = null;
        try {
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            this.listRemoteDirectory(sftp, remoteDir, out, recurse);
        }
        finally {
            if (sftp != null) {
                sftp.exit();
            }
            sftp.disconnect();
        }
        return out;
    }

    public int executeCmd(String cmd, Level level) throws JSchException {
        Channel channel = null;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmd);
            channel.setInputStream(null);
            ((ChannelExec)channel).setErrStream((OutputStream)new PrintStream(new LoggingOutputStream(logger, level)));
            channel.connect();
            while (!channel.isClosed()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int n = channel.getExitStatus();
            return n;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    public int executeCmd(String cmd, StringBuilder builder, boolean setErrStream) throws JSchException, IOException {
        Channel channel = null;
        int exitStatus = 0;
        try {
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(cmd);
            channel.setInputStream(null);
            if (setErrStream) {
                ((ChannelExec)channel).setErrStream((OutputStream)new PrintStream(new LoggingOutputStream(logger, Level.ERROR)));
            }
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                if (in.available() > 0) {
                    int i = in.read(tmp, 0, 1024);
                    if (i >= 0) {
                        builder.append(new String(tmp, 0, i));
                        continue;
                    }
                }
                if (channel.isClosed()) {
                    exitStatus = channel.getExitStatus();
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
        return exitStatus;
    }

    public void copyFileToRemote(File localFile) throws JSchException, SftpException {
        ChannelSftp sftp = null;
        try {
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            sftp.put(localFile.getAbsolutePath().replace("\\", "/"), localFile.getName());
        }
        finally {
            if (sftp != null) {
                sftp.exit();
            }
            sftp.disconnect();
        }
    }

    public void copyFileToRemote(File localFile, String remoteDirectory) throws JSchException, SftpException {
        ChannelSftp sftp = null;
        try {
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            sftp.cd(remoteDirectory);
            sftp.put(localFile.getAbsolutePath().replace("\\", "/"), localFile.getName());
        }
        finally {
            if (sftp != null) {
                sftp.exit();
            }
            sftp.disconnect();
        }
    }

    public File copyFileFromRemote(String localDir, File remoteFile, boolean preserveRemotePath) throws SftpException, JSchException {
        ArrayList<File> files = new ArrayList<File>();
        files.add(remoteFile);
        return this.copyFilesFromRemote(localDir, files, preserveRemotePath).get(0);
    }

    public List<File> copyFilesFromRemote(String localDir, List<File> remoteFiles, boolean preserveRemotePath) throws SftpException, JSchException {
        ChannelSftp sftp = null;
        ArrayList<File> out = new ArrayList<File>();
        try {
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            File ld = new File(localDir);
            ld.mkdirs();
            for (File remoteFile : remoteFiles) {
                String path = preserveRemotePath ? remoteFile.getPath() : remoteFile.getName();
                File dst = new File(localDir, path);
                dst.getParentFile().mkdirs();
                sftp.get(remoteFile.getPath().replace("\\", "/"), dst.getPath().replace("\\", "/"));
                out.add(dst);
            }
        }
        finally {
            if (sftp != null) {
                sftp.exit();
            }
            sftp.disconnect();
        }
        return out;
    }

    public void disconnect() {
        this.session.disconnect();
    }
}

