/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.util.concurrent.Callable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.SSHSession;
import repast.simphony.batch.ssh.SSHSessionFactory;

public class RemoteDonePoller
implements Callable<Void> {
    Logger logger = Logger.getLogger(RemoteDonePoller.class);
    private String directory;
    private long frequency;
    private RemoteSession remote;

    public RemoteDonePoller(RemoteSession remote, String directory, long frequency) {
        this.remote = remote;
        this.directory = directory;
        this.frequency = frequency;
    }

    @Override
    public Void call() throws Exception {
        SSHSession session = null;
        try {
            session = SSHSessionFactory.getInstance().create(this.remote);
            String cmd = String.format("cd %s;test -e %s", this.directory, "DONE");
            int exitStatus = 1;
            while (exitStatus != 0) {
                try {
                    Thread.sleep(this.frequency);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                exitStatus = session.executeCmd(cmd, Level.ERROR);
                this.logger.info((Object)String.format("Polled %s on %s for %s: %s", this.directory, this.remote.getHost(), "DONE", exitStatus == 0 ? "yes" : "no"));
            }
        }
        finally {
            if (session != null) {
                session.disconnect();
            }
        }
        return null;
    }
}

