/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import repast.simphony.batch.ssh.OutputPattern;

public class OutputPatternPropsParser {
    public List<OutputPattern> parse(String file) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(file));
        return this.run(props);
    }

    public List<OutputPattern> parse(Properties props) throws IOException {
        return this.run(props);
    }

    private List<OutputPattern> run(Properties props) throws IOException {
        OutputPatternBuilder builder = new OutputPatternBuilder();
        for (Object key : props.keySet()) {
            if (!key.toString().startsWith("output.pattern")) continue;
            String[] vals = key.toString().trim().split("\\.");
            this.checkVals(key.toString(), vals);
            int id = Integer.parseInt(vals[2].trim());
            this.setValue(builder, id, vals[3].trim(), props.getProperty(key.toString()));
        }
        return new ArrayList<OutputPattern>(builder.getPatterns());
    }

    private void setValue(OutputPatternBuilder builder, int id, String type, String val) throws IOException {
        if (type.equals("pattern")) {
            builder.setPattern(id, val.trim());
        } else if (type.equals("path")) {
            builder.setPath(id, val.trim());
        } else if (type.equals("header")) {
            builder.setHeader(id, Boolean.parseBoolean(val.trim()));
        } else if (type.equals("concatenate")) {
            builder.setConcat(id, Boolean.parseBoolean(val.trim()));
        }
    }

    private void checkVals(String key, String[] vals) throws IOException {
        if (vals.length != 4) {
            throw new IOException("Invalid properties configuration for '" + key + "': expected output.pattern.X.[pattern|path|header|concatenate] where X is a numeric id");
        }
        try {
            Integer.parseInt(vals[2].trim());
        }
        catch (NumberFormatException ex) {
            throw new IOException("Invalid output pattern configuration:" + key);
        }
        if (!(vals[3].equals("pattern") || vals[3].equals("path") || vals[3].equals("header") || vals[3].equals("concatenate"))) {
            throw new IOException("Invalid output pattern configuration: " + key);
        }
    }

    private static class OutputPatternBuilder {
        private Map<Integer, OutputPattern> patterns = new HashMap<Integer, OutputPattern>();

        private OutputPatternBuilder() {
        }

        private OutputPattern getPattern(int id) {
            OutputPattern pattern = this.patterns.get(id);
            if (pattern == null) {
                pattern = new OutputPattern();
                this.patterns.put(id, pattern);
            }
            return pattern;
        }

        public void setPattern(int id, String pattern) {
            OutputPattern oPattern = this.getPattern(id);
            oPattern.setPattern(pattern);
        }

        public void setPath(int id, String path) {
            OutputPattern oPattern = this.getPattern(id);
            oPattern.setPath(path);
        }

        public void setConcat(int id, boolean concat) {
            OutputPattern oPattern = this.getPattern(id);
            oPattern.setConcatenate(concat);
        }

        public void setHeader(int id, boolean header) {
            OutputPattern oPattern = this.getPattern(id);
            oPattern.setHeader(header);
        }

        public Collection<OutputPattern> getPatterns() throws IOException {
            for (Map.Entry<Integer, OutputPattern> entry : this.patterns.entrySet()) {
                OutputPattern pattern = entry.getValue();
                if (pattern.getPath() == null) {
                    throw new IOException("Invalid output pattern: output pattern " + entry.getKey() + " is missing a path value");
                }
                if (pattern.getPattern() != null) continue;
                throw new IOException("Invalid output pattern: output pattern " + entry.getKey() + " is missing a pattern value");
            }
            return this.patterns.values();
        }
    }
}

