/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.OutputPattern;

public abstract class OutputFinder {
    private List<OutputPattern> filePatterns = new ArrayList<OutputPattern>();
    protected static Logger logger = Logger.getLogger(OutputFinder.class);

    public void addPattern(OutputPattern pattern) {
        if (!pattern.getPattern().startsWith("glob:")) {
            pattern.setPattern(pattern.getPattern().replace("./", ""));
            pattern.setPattern(pattern.getPattern().replace(".\\", ""));
            pattern.setPattern("glob:" + pattern.getPattern());
        }
        this.filePatterns.add(pattern);
    }

    public void addPatterns(Collection<OutputPattern> patterns) {
        for (OutputPattern pattern : patterns) {
            this.addPattern(pattern);
        }
    }

    protected List<MatchedFiles> createMatches(boolean useWindowsSeparators) {
        ArrayList<MatchedFiles> list = new ArrayList<MatchedFiles>();
        Collections.sort(this.filePatterns, new Comparator<OutputPattern>(){

            @Override
            public int compare(OutputPattern o1, OutputPattern o2) {
                String p1 = o1.getPattern();
                String p2 = o2.getPattern();
                return p1.length() > p2.length() ? -1 : (p1.length() == p2.length() ? 0 : 1);
            }
        });
        for (OutputPattern outPattern : this.filePatterns) {
            String pattern = outPattern.getPattern();
            if (useWindowsSeparators) {
                outPattern.setPattern(pattern.replace("/", "\\\\"));
            }
            list.add(new MatchedFiles(outPattern));
        }
        return list;
    }

    protected void findFiles(List<MatchedFiles> matchers, List<String> allFiles, String instanceDir) {
        block0: for (String file : allFiles) {
            for (MatchedFiles matcher : matchers) {
                if (!matcher.matches(new File(file).toPath())) continue;
                matcher.addFile(new File(instanceDir, file));
                continue block0;
            }
        }
        for (MatchedFiles matcher : matchers) {
            if (!matcher.isEmpty()) continue;
            logger.warn((Object)("No model output found matching " + matcher.getPattern().getPattern() + " in " + instanceDir));
        }
    }

    protected static class Instance {
        String dir;
        List<File> files = new ArrayList<File>();

        public Instance(String dir) {
            this.dir = dir;
        }

        public String getDirectory() {
            return this.dir;
        }

        public void addFile(File file) {
            this.files.add(file);
        }

        public List<File> getFiles() {
            return this.files;
        }
    }
}

