/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OutputAggregator {
    private List<File> findOutput(String baseName, List<File> files) {
        ArrayList<File> chosen = new ArrayList<File>();
        int index = baseName.indexOf(".");
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        for (File file : files) {
            if (!file.getName().startsWith(baseName)) continue;
            chosen.add(file);
        }
        return chosen;
    }

    private String makePFName(String fname) {
        int index = fname.lastIndexOf(".");
        String pfname = null;
        pfname = index == -1 ? String.valueOf(fname) + "." + "batch_param_map" : String.valueOf(fname.substring(0, index)) + "." + "batch_param_map" + fname.substring(index, fname.length());
        return pfname;
    }

    public String getNonParamMapFile(List<File> files) {
        for (File file : files) {
            if (file.getName().contains("batch_param_map")) continue;
            return file.getName();
        }
        return null;
    }

    public void run(List<String> baseOutputNames, List<File> outputFiles, String aggOutputDirectory) throws IOException {
        Collections.sort(baseOutputNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.length() < s2.length() ? 1 : (s1.length() == s2.length() ? 0 : -1);
            }
        });
        for (String baseName : baseOutputNames) {
            List<File> output = this.findOutput(baseName, outputFiles);
            outputFiles.removeAll(output);
            if (output.isEmpty()) {
                throw new IOException("Output files are missing");
            }
            String fname = this.getNonParamMapFile(output);
            if (fname == null) {
                throw new IOException("Error while aggregating output");
            }
            String pfname = this.makePFName(fname);
            BufferedWriter fout = null;
            BufferedWriter pfout = null;
            try {
                fout = new BufferedWriter(new FileWriter(String.valueOf(aggOutputDirectory) + "/" + fname));
                pfout = new BufferedWriter(new FileWriter(String.valueOf(aggOutputDirectory) + "/" + pfname));
                boolean fskip = false;
                boolean pfskip = false;
                for (File file : output) {
                    if (file.getName().contains("batch_param_map")) {
                        this.process(pfout, file, pfskip);
                        pfskip = true;
                        continue;
                    }
                    this.process(fout, file, fskip);
                    fskip = true;
                }
            }
            finally {
                if (fout != null) {
                    fout.close();
                }
                if (pfout != null) {
                    pfout.close();
                }
            }
        }
    }

    private void process(BufferedWriter out, File file, boolean skip) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            if (skip) {
                reader.readLine();
            }
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
    }
}

