/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.ModelArchiveConfiguratorException;
import repast.simphony.batch.ssh.Session;

public class ModelArchiveConfigurator {
    private static final byte[] BUFFER = new byte[0x400000];
    private static final String PARAMS_FILE = "scenario.rs/batch_unrolled_params.txt";
    private static final String PROP_FILE_CONTENTS = "unrolled.batch.parameter.file=./scenario.rs/batch_unrolled_params.txt\nscenario.directory=./scenario.rs\nworking.directory=./\nrepast.lib.directory=./lib\n";

    public File configure(Session session, Configuration config) throws ModelArchiveConfiguratorException {
        File file = null;
        ZipFile zip = null;
        ZipOutputStream out = null;
        try {
            try {
                file = File.createTempFile(String.valueOf(session.getUser()) + "_" + session.getHost(), ".zip");
                out = new ZipOutputStream(new FileOutputStream(file));
                zip = new ZipFile(config.getModelArchive());
                Enumeration<? extends ZipEntry> iter = zip.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry entry = iter.nextElement();
                    if (entry.getName().equals("local_batch_run.properties")) continue;
                    out.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        this.copy(zip.getInputStream(entry), out);
                    }
                    out.closeEntry();
                }
                ZipEntry entry = new ZipEntry("local_batch_run.properties");
                out.putNextEntry(entry);
                String params = config.getBatchParamsFile();
                if (!params.startsWith("./")) {
                    params = "./" + params;
                }
                String contents = "unrolled.batch.parameter.file=./scenario.rs/batch_unrolled_params.txt\nscenario.directory=./scenario.rs\nworking.directory=./\nrepast.lib.directory=./lib\ninstance.count = " + session.getInstances() + "\n" + "batch.parameter.file = " + params;
                contents = String.valueOf(contents) + "\nvm.arguments = " + config.getVMArguments();
                out.write(contents.getBytes());
                out.closeEntry();
                entry = new ZipEntry(PARAMS_FILE);
                out.putNextEntry(entry);
                this.copy(new BufferedInputStream(new FileInputStream(session.getInput())), out);
                out.closeEntry();
                out.close();
            }
            catch (IOException ex) {
                throw new ModelArchiveConfiguratorException(ex);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    private void copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        while ((bytesRead = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, bytesRead);
        }
    }
}

