/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import repast.simphony.batch.ssh.OutputPattern;

public class MatchedFiles {
    private OutputPattern pattern;
    private PathMatcher matcher;
    private List<File> files = new ArrayList<File>();

    public MatchedFiles(OutputPattern pattern) {
        this.pattern = pattern;
        this.matcher = FileSystems.getDefault().getPathMatcher(pattern.getPattern());
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public OutputPattern getPattern() {
        return this.pattern;
    }

    public boolean matches(Path path) {
        return this.matcher.matches(path);
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public List<File> getFiles() {
        return new ArrayList<File>(this.files);
    }

    public void addAllFiles(Collection<File> files) {
        this.files.addAll(files);
    }

    private void process(BufferedWriter out, File file, boolean skip) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = null;
            if (skip) {
                reader.readLine();
            }
            while ((line = reader.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void renamePath(Path path) throws IOException {
        if (path.toFile().exists()) {
            String suffix = new SimpleDateFormat("yyyy.MMM.dd.HH_mm_ss").format(new Date());
            Files.move(path, path.resolveSibling(String.valueOf(path.getFileName().toFile().getName()) + "_" + suffix), new CopyOption[0]);
        }
    }

    private void copyFiles(String outputDir) throws IOException {
        Path outDir = FileSystems.getDefault().getPath(outputDir, this.pattern.getPath());
        this.renamePath(outDir);
        outDir.toFile().mkdirs();
        HashMap<String, Integer> suffixMap = new HashMap<String, Integer>();
        for (File file : this.files) {
            String name = file.getName();
            Integer count = (Integer)suffixMap.get(name);
            if (count == null) {
                count = new Integer(0);
            }
            suffixMap.put(name, count + 1);
            String suffix = "_" + (count + 1);
            int index = name.lastIndexOf(".");
            name = index == -1 ? String.valueOf(name) + suffix : String.valueOf(name.substring(0, index)) + suffix + name.substring(index);
            Path target = new File(outDir.toFile(), name).toPath();
            Files.copy(file.toPath(), target, new CopyOption[0]);
        }
    }

    public void aggregateOutput(String outputDir) throws IOException {
        block12: {
            if (this.pattern.isConcatenate()) {
                File f = new File(outputDir, this.pattern.getPath());
                this.renamePath(f.toPath());
                if (!f.getParentFile().exists()) {
                    f.getParentFile().mkdirs();
                }
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
                    boolean skip = false;
                    for (File file : this.files) {
                        this.process(out, file, skip);
                        skip = this.pattern.isHeader();
                    }
                    break block12;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.copyFiles(outputDir);
        }
    }
}

