/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import repast.simphony.batch.ProcessOutputLogWriter;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.LocalDonePoller;
import repast.simphony.batch.ssh.LocalOutputFinder;
import repast.simphony.batch.ssh.LocalStatusCopier;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.ModelArchiveConfigurator;
import repast.simphony.batch.ssh.ModelArchiveConfiguratorException;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.SessionException;
import repast.simphony.batch.ssh.StatusException;
import repast.simphony.util.FileUtils;

public class LocalSession
implements Session {
    private static Logger logger = Logger.getLogger(LocalSession.class);
    private String input = "";
    int instances = 0;
    String workingDir;
    private File modelArchive = null;
    private String localRunningDirectory = null;
    private Map<Integer, RunningStatus> stati = new HashMap<Integer, RunningStatus>();

    @Override
    public String getHost() {
        return "localhost";
    }

    @Override
    public String getUser() {
        return System.getProperty("user.name");
    }

    @Override
    public String getId() {
        return String.valueOf(this.getUser()) + "@" + this.getHost();
    }

    @Override
    public int getInstances() {
        return this.instances;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public void setRunStatus(int instance, RunningStatus status) {
        this.stati.put(instance, status);
    }

    @Override
    public RunningStatus getStatus(int instance) {
        return this.stati.get(instance);
    }

    @Override
    public Callable<Void> createDonePoller(long frequency) {
        File localDir = new File(this.workingDir, this.localRunningDirectory);
        return new LocalDonePoller(localDir.getAbsolutePath(), frequency);
    }

    @Override
    public void copyCompletionStatus(String outDirectory) throws StatusException {
        LocalStatusCopier copier = new LocalStatusCopier();
        File localDir = new File(this.workingDir, this.localRunningDirectory);
        copier.run(this, localDir, outDirectory);
    }

    @Override
    public List<MatchedFiles> findOutput(List<OutputPattern> patterns) throws StatusException {
        LocalOutputFinder finder = new LocalOutputFinder();
        finder.addPatterns(patterns);
        File localDir = new File(this.workingDir, this.localRunningDirectory);
        logger.info((Object)String.format("Finding output on localhost in %s", localDir.getPath()));
        return finder.run(localDir);
    }

    @Override
    public void retrieveRunCompletionStatus() throws StatusException {
        File statusFile = new File(this.workingDir, this.localRunningDirectory);
        statusFile = new File(statusFile, "status_output.properties");
        Properties props = new Properties();
        try {
            props.load(new FileReader(statusFile));
            for (String key : props.stringPropertyNames()) {
                this.setRunStatus(Integer.valueOf(key), RunningStatus.valueOf(props.getProperty(key)));
            }
        }
        catch (IOException ex) {
            String msg = String.format("Error reading local status file '%s'", statusFile.getPath());
            throw new StatusException(msg, ex);
        }
    }

    @Override
    public void runModel() throws SessionException {
        if (this.modelArchive == null) {
            throw new SessionException("Model has not been initialized for running. Call initModel first.");
        }
        File localDir = new File(this.workingDir, this.localRunningDirectory);
        this.unzip(localDir);
        logger.info((Object)"Running model on localhost ...");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(localDir);
        if (SystemUtils.IS_OS_WINDOWS) {
            builder.command("java", "-cp", "\"./lib/*\"", "repast.simphony.batch.LocalDriver", "local_batch_run.properties");
        } else {
            builder.command("java", "-cp", "./lib/*", "repast.simphony.batch.LocalDriver", "local_batch_run.properties");
        }
        builder.redirectErrorStream(true);
        ProcessRunner runner = new ProcessRunner(builder);
        new Thread(runner).start();
    }

    private void unzip(File localDir) throws SessionException {
        File zipFile = new File(localDir, this.modelArchive.getName());
        logger.info((Object)String.format("Unzipping model %s", zipFile.getPath()));
        ZipFile zip = null;
        try {
            try {
                zip = new ZipFile(zipFile);
                Enumeration<? extends ZipEntry> iter = zip.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry entry = iter.nextElement();
                    File file = new File(localDir, entry.getName());
                    if (entry.isDirectory()) {
                        file.mkdirs();
                        continue;
                    }
                    ReadableByteChannel source = Channels.newChannel(zip.getInputStream(entry));
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileChannel dstChannel = new FileOutputStream(file).getChannel();
                    dstChannel.transferFrom(source, 0L, entry.getSize());
                    dstChannel.close();
                    source.close();
                }
            }
            catch (ZipException ex) {
                String msg = String.format("Error while unzipping model archive %s", zipFile.getPath());
                throw new SessionException(msg, ex);
            }
            catch (IOException ex) {
                String msg = String.format("Error while unzipping model archive %s", zipFile.getPath());
                throw new SessionException(msg, ex);
            }
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    @Override
    public void initModelArchive(Configuration config, String directory) throws ModelArchiveConfiguratorException, SessionException {
        this.localRunningDirectory = directory;
        ModelArchiveConfigurator archConfig = new ModelArchiveConfigurator();
        this.modelArchive = archConfig.configure(this, config);
        File dest = new File(this.workingDir, directory);
        if (!dest.exists()) {
            dest.mkdirs();
        }
        logger.info((Object)String.format("%n\tCopying locally %s to %n%s ...", this.modelArchive.getAbsolutePath(), dest.getAbsolutePath()));
        dest = new File(dest, this.modelArchive.getName());
        try {
            FileUtils.copyFile((File)this.modelArchive, (File)dest);
        }
        catch (IOException ex) {
            String msg = String.format("Error while copying %s to %s", this.modelArchive.getAbsolutePath(), dest.getAbsolutePath());
            throw new SessionException(msg, ex);
        }
        logger.info((Object)"Copying Finished.");
    }

    private static class ProcessRunner
    implements Runnable {
        ProcessBuilder builder;

        public ProcessRunner(ProcessBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void run() {
            ProcessOutputLogWriter logWriter = new ProcessOutputLogWriter(logger);
            try {
                Process process = this.builder.start();
                logWriter.captureOutput(process);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
        }
    }
}

