/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.OutputFinder;
import repast.simphony.batch.ssh.StatusException;

public class LocalOutputFinder
extends OutputFinder {
    private List<MatchedFiles> findOutputFiles(List<String> instanceDirs) throws StatusException {
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        List<MatchedFiles> matchers = this.createMatches(SystemUtils.IS_OS_WINDOWS);
        for (String dir : instanceDirs) {
            Path instanceDir = new File(dir).toPath();
            FileGatherer fileGatherer = new FileGatherer(instanceDir);
            try {
                Files.walkFileTree(instanceDir, opts, Integer.MAX_VALUE, fileGatherer);
            }
            catch (IOException ex) {
                throw new StatusException(ex);
            }
            this.findFiles(matchers, fileGatherer.files, dir);
        }
        return matchers;
    }

    public List<MatchedFiles> run(File instanceParentDirectory) throws StatusException {
        ArrayList<String> instances = new ArrayList<String>();
        File[] fileArray = instanceParentDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.getName().contains("instance_")) {
                instances.add(dir.getAbsolutePath());
            }
            ++n2;
        }
        return this.findOutputFiles(instances);
    }

    private static class FileGatherer
    extends SimpleFileVisitor<Path> {
        private List<String> files = new ArrayList<String>();
        private Path instanceDir;

        public FileGatherer(Path instanceDir) {
            this.instanceDir = instanceDir;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.files.add(this.instanceDir.relativize(file).toString());
            return FileVisitResult.CONTINUE;
        }
    }
}

