/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import repast.simphony.batch.parameter.ParametersToInput;
import repast.simphony.batch.ssh.BatchParameterChunkerException;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.Session;
import repast.simphony.parameter.ParameterTreeSweeper;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.xml.XMLSweeperProducer;

public class BatchParameterChunker {
    private Configuration config;

    public BatchParameterChunker(Configuration config) {
        this.config = config;
    }

    private int getRunCount(XMLSweeperProducer producer) throws IOException {
        int count = 0;
        ParameterTreeSweeper sweeper = producer.getParameterSweeper();
        Parameters params = producer.getParameters();
        while (!sweeper.atEnd()) {
            sweeper.next(params);
            ++count;
        }
        return count;
    }

    public void run() throws BatchParameterChunkerException {
        ZipFile zipfile = null;
        ZipEntry entry = null;
        try {
            try {
                zipfile = new ZipFile(this.config.getModelArchive());
                entry = zipfile.getEntry(this.config.getBatchParamsFile());
                if (entry == null) {
                    throw new BatchParameterChunkerException(String.format("Unable to find batch param file '%s' in model archive '%s'", this.config.getBatchParamsFile(), this.config.getModelArchive()));
                }
                int runCount = this.getRunCount(new XMLSweeperProducer(zipfile.getInputStream(entry)));
                ParametersToInput toInput = new ParametersToInput(zipfile.getInputStream(entry));
                this.createInstanceInput(toInput, runCount);
            }
            catch (IOException ex) {
                throw new BatchParameterChunkerException(ex);
            }
            catch (ParserConfigurationException e) {
                throw new BatchParameterChunkerException(e);
            }
            catch (SAXException e) {
                throw new BatchParameterChunkerException(e);
            }
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createInstanceInput(ParametersToInput toInput, int runCount) throws IOException {
        int instances = 0;
        for (Session session : this.config.sessions()) {
            instances += session.getInstances();
        }
        long[] lArray = new long[instances];
        int val = runCount / instances;
        int i = 0;
        while (i < lArray.length) {
            lArray[i] = val;
            ++i;
        }
        long diff = runCount - val * instances;
        if (diff > 0L) {
            int i2 = 0;
            while (i2 < lArray.length) {
                lArray[i2] = lArray[i2] + 1L;
                if (--diff == 0L) break;
                ++i2;
            }
        }
        Iterator<String> lines = toInput.formatForInput();
        int start = 0;
        int index = 1;
        for (Session session : this.config.sessions()) {
            int end = start + session.getInstances();
            int numRuns = 0;
            int i3 = start;
            while (i3 < end) {
                numRuns = (int)((long)numRuns + lArray[i3]);
                ++i3;
            }
            start = end;
            File file = new File(System.getProperty("java.io.tmpdir"), String.valueOf(new Date().getTime()) + "unrolled_params_" + index + ".txt");
            session.setInput(file.getCanonicalPath());
            try {
                Throwable throwable = null;
                Object throwable2 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    int i4 = 0;
                    while (i4 < numRuns) {
                        writer.append(lines.next());
                        writer.append("\n");
                        ++i4;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (NoSuchElementException ex) {
                ex.printStackTrace();
            }
            ++index;
        }
    }
}

