/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch.ssh;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class BaseOutputNamesFinder {
    private static final QName FILENAME = new QName("fileName");
    private static final QName TIME_STAMP = new QName("addTimeStamp");

    public List<FinderOutput> find(String scenarioDirectory) throws IOException, XMLStreamException {
        ArrayList<FinderOutput> output = new ArrayList<FinderOutput>();
        File[] fileArray = new File(scenarioDirectory).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith("repast.simphony.action.file_sink")) {
                output.add(this.process(new FileInputStream(file)));
            }
            ++n2;
        }
        return output;
    }

    public FinderOutput find(InputStream fileSinkDescriptor) throws IOException, XMLStreamException {
        return this.process(fileSinkDescriptor);
    }

    private FinderOutput process(InputStream in) throws IOException, XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(in);
        String name = null;
        Boolean ts = null;
        try {
            while (reader.hasNext()) {
                XMLEvent evt = reader.nextEvent();
                if (evt.isStartElement()) {
                    StartElement elm = evt.asStartElement();
                    if (elm.getName().equals(FILENAME)) {
                        name = reader.nextEvent().asCharacters().getData();
                    } else if (elm.getName().equals(TIME_STAMP)) {
                        String val = reader.nextEvent().asCharacters().getData();
                        ts = Boolean.valueOf(val);
                    }
                }
                if (name == null || ts == null) continue;
                break;
            }
        }
        finally {
            reader.close();
        }
        return new FinderOutput(name, ts);
    }

    public class FinderOutput {
        private String fname;
        private boolean ts;

        public FinderOutput(String fname, boolean ts) {
            this.fname = fname;
            this.ts = ts;
        }

        public String getFileName() {
            return this.fname;
        }

        public boolean hasTimestamp() {
            return this.ts;
        }
    }
}

