/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.PropertyConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import repast.simphony.batch.RunningStatus;
import repast.simphony.batch.ssh.BaseOutputNamesFinder;
import repast.simphony.batch.ssh.Configuration;
import repast.simphony.batch.ssh.DefaultOutputPatternCreator;
import repast.simphony.batch.ssh.LocalOutputFinder;
import repast.simphony.batch.ssh.MatchedFiles;
import repast.simphony.batch.ssh.OutputPattern;
import repast.simphony.batch.ssh.RemoteSession;
import repast.simphony.batch.ssh.RemoteStatusCopier;
import repast.simphony.batch.ssh.RemoteStatusGetter;
import repast.simphony.batch.ssh.SSHSessionFactory;
import repast.simphony.batch.ssh.Session;
import repast.simphony.batch.ssh.StatusException;

public class RemoteOutputTest {
    private static final String REMOTE_DIR = "for_testing_simphony_model";
    private static final String[] NO_HEADER_OUTPUT = new String[]{"instance_4, output", "instance_3, output", "instance_1, output", "instance_2, output"};
    private Set<File> expectedFiles = new HashSet<File>();

    static {
        PropertyConfigurator.configure((String)"./config/SSH.MessageCenter.log4j.properties");
        String home = System.getProperty("user.home");
        SSHSessionFactory.init(String.valueOf(home) + "/.ssh");
    }

    @Before
    public void setUp() {
        File top = new File("./test_data/for_testing_simphony_model");
        int i = 1;
        while (i < 5) {
            File dir = new File(top, "instance_" + i);
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.expectedFiles.add(file);
                ++n2;
            }
            ++i;
        }
    }

    private void getLines(Set<String> lines, String file) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                lines.add(line.trim());
            }
        }
    }

    @Test
    public void testBaseNameFinder() throws IOException, XMLStreamException {
        List<BaseOutputNamesFinder.FinderOutput> fsFound = new BaseOutputNamesFinder().find("./test_data/test_scenario.rs");
        Assert.assertEquals((long)2L, (long)fsFound.size());
        HashSet<String> expected = new HashSet<String>();
        expected.add("ModelOutput.txt");
        expected.add("ModelOutput2.txt");
        for (BaseOutputNamesFinder.FinderOutput fo : fsFound) {
            Assert.assertTrue((boolean)expected.remove(fo.getFileName()));
        }
    }

    @Test
    public void testBaseNameFinderZip() throws IOException, XMLStreamException {
        BaseOutputNamesFinder finder = new BaseOutputNamesFinder();
        ArrayList<BaseOutputNamesFinder.FinderOutput> baseNames = new ArrayList<BaseOutputNamesFinder.FinderOutput>();
        ZipFile zip = new ZipFile("./test_data/test_scenario.rs/complete_model.zip");
        Enumeration<? extends ZipEntry> iter = zip.entries();
        while (iter.hasMoreElements()) {
            ZipEntry entry = iter.nextElement();
            if (!entry.getName().startsWith("scenario.rs/repast.simphony.action.file_sink")) continue;
            baseNames.add(finder.find(zip.getInputStream(entry)));
        }
        zip.close();
        Assert.assertEquals((long)1L, (long)baseNames.size());
        Assert.assertEquals((Object)"ModelOutput.txt", baseNames.get(0));
    }

    @Test
    public void testAggregationNoHeader() throws StatusException, IOException {
        File f = new File("./test_out/no_header.txt");
        if (f.exists()) {
            f.delete();
        }
        LocalOutputFinder finder = new LocalOutputFinder();
        OutputPattern pattern = new OutputPattern();
        pattern.setPattern("MyCustomOutput.txt");
        pattern.setConcatenate(true);
        pattern.setPath("no_header.txt");
        pattern.setHeader(false);
        finder.addPattern(pattern);
        List<MatchedFiles> files = finder.run(new File("./test_data/for_testing_simphony_model"));
        Assert.assertEquals((long)1L, (long)files.size());
        files.get(0).aggregateOutput("./test_out");
        f = new File("./test_out/no_header.txt");
        Assert.assertTrue((boolean)f.exists());
        HashSet<String> expected = new HashSet<String>(Arrays.asList(NO_HEADER_OUTPUT));
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                Assert.assertTrue((boolean)expected.remove(line));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testNoAggregation() throws StatusException, IOException {
        File f = new File("./test_out/custom output");
        if (f.exists()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            f.delete();
        }
        LocalOutputFinder finder = new LocalOutputFinder();
        OutputPattern pattern = new OutputPattern();
        pattern.setPattern("MyCustomOutput{2,}.txt");
        pattern.setConcatenate(false);
        pattern.setPath("custom output");
        pattern.setHeader(false);
        finder.addPattern(pattern);
        List<MatchedFiles> files = finder.run(new File("./test_data/for_testing_simphony_model"));
        Assert.assertEquals((long)1L, (long)files.size());
        files.get(0).aggregateOutput("./test_out");
        Path path = FileSystems.getDefault().getPath("./test_out/custom output", new String[0]);
        Assert.assertTrue((boolean)path.toFile().exists());
        Assert.assertTrue((boolean)path.toFile().isDirectory());
        Assert.assertEquals((long)8L, (long)path.toFile().list().length);
        int i = 1;
        while (i < 5) {
            File file = new File("./test_out/custom output/MyCustomOutput_" + i + ".txt");
            Assert.assertTrue((boolean)file.exists());
            file = new File("./test_out/custom output/MyCustomOutput2_" + i + ".txt");
            Assert.assertTrue((boolean)file.exists());
            ++i;
        }
    }

    @Test
    public void testAggregator() throws IOException, XMLStreamException, StatusException {
        LocalOutputFinder finder = new LocalOutputFinder();
        DefaultOutputPatternCreator creator = new DefaultOutputPatternCreator("ModelOutput.txt", true);
        finder.addPattern(creator.getParamMapPattern());
        finder.addPattern(creator.getFileSinkOutputPattern());
        DefaultOutputPatternCreator creator2 = new DefaultOutputPatternCreator("ModelOutput2.txt", true);
        finder.addPattern(creator2.getParamMapPattern());
        finder.addPattern(creator2.getFileSinkOutputPattern());
        List<MatchedFiles> files = finder.run(new File("./test_data/for_testing_simphony_model"));
        Assert.assertEquals((long)4L, (long)files.size());
        for (MatchedFiles mf : files) {
            mf.aggregateOutput("./test_out");
        }
        HashSet<String> expOut = new HashSet<String>();
        HashSet<String> expPOut = new HashSet<String>();
        for (File file : this.expectedFiles) {
            if (file.getName().contains("batch_param_map")) {
                this.getLines(expPOut, file.getPath());
                continue;
            }
            this.getLines(expOut, file.getPath());
        }
        Assert.assertEquals((Object)true, (Object)(expOut.size() > 0 ? 1 : 0));
        Assert.assertEquals((Object)true, (Object)(expPOut.size() > 0 ? 1 : 0));
        File model = new File("./test_out/" + creator.getFileSinkOutputPattern().getPath());
        this.testOutput(expOut, model);
        File modelP = new File("./test_out/" + creator.getParamMapPattern().getPath());
        this.testOutput(expPOut, modelP);
        File model2 = new File("./test_out/" + creator2.getFileSinkOutputPattern().getPath());
        this.testOutput(expOut, model2);
        File modelP2 = new File("./test_out/" + creator2.getParamMapPattern().getPath());
        this.testOutput(expPOut, modelP2);
        model.delete();
        modelP.delete();
        model2.delete();
        modelP2.delete();
    }

    private Session getTestingRemote(Configuration config) {
        for (Session session : config.sessions()) {
            if (!session.getUser().equals("sshtesting")) continue;
            return session;
        }
        return null;
    }

    @Test
    public void testRemoteStatus() throws StatusException, IOException {
        File exp2;
        File exp1 = new File("./test_out/sshtesting_128.135.250.205_1_failure.txt");
        if (exp1.exists()) {
            exp1.delete();
        }
        if ((exp2 = new File("./test_out/sshtesting_128.135.250.205_3_warn.txt")).exists()) {
            exp2.delete();
        }
        Configuration config = new Configuration("./test_data/test_remote_config.properties");
        RemoteStatusGetter getter = new RemoteStatusGetter();
        RemoteSession remote = (RemoteSession)this.getTestingRemote(config);
        getter.run(remote, REMOTE_DIR);
        RemoteStatusCopier copier = new RemoteStatusCopier();
        copier.run(remote, REMOTE_DIR, "./test_out");
        Assert.assertEquals((Object)true, (Object)exp1.exists());
        Assert.assertEquals((Object)true, (Object)exp2.exists());
    }

    private void testOutput(Set<String> expected, File file) throws IOException {
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                Assert.assertEquals((String)line, (Object)true, (Object)expected.contains(line));
            }
        }
    }

    @Test
    public void testRemoteStatusGetter() throws IOException, StatusException {
        Configuration config = new Configuration("./test_data/test_remote_config.properties");
        RemoteStatusGetter getter = new RemoteStatusGetter();
        RemoteSession remote = (RemoteSession)this.getTestingRemote(config);
        getter.run(remote, REMOTE_DIR);
        Assert.assertEquals((Object)((Object)remote.getStatus(1)), (Object)((Object)RunningStatus.FAILURE));
        Assert.assertEquals((Object)((Object)remote.getStatus(2)), (Object)((Object)RunningStatus.OK));
        Assert.assertEquals((Object)((Object)remote.getStatus(3)), (Object)((Object)RunningStatus.WARN));
        Assert.assertEquals((Object)((Object)remote.getStatus(4)), (Object)((Object)RunningStatus.OK));
    }
}

