/*
 * Decompiled with CFR 0.152.
 */
package repast.simphony.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import repast.simphony.batch.BatchScenarioLoader;
import repast.simphony.batch.BatchScheduleRunner;
import repast.simphony.engine.controller.DefaultController;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultRunEnvironmentBuilder;
import repast.simphony.engine.environment.RunEnvironmentBuilder;
import repast.simphony.engine.environment.RunListener;
import repast.simphony.engine.environment.Runner;
import repast.simphony.parameter.ParameterSetter;
import repast.simphony.parameter.Parameters;
import repast.simphony.parameter.ParametersCreator;
import repast.simphony.parameter.SweeperProducer;
import repast.simphony.scenario.ScenarioLoadException;
import repast.simphony.scenario.ScenarioLoader;
import simphony.util.messages.MessageCenter;

public class OneRunBatchRunner
implements RunListener {
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(OneRunBatchRunner.class);
    private RunEnvironmentBuilder runEnvironmentBuilder;
    protected ORBController controller;
    protected boolean pause = false;
    protected Object monitor = new Object();
    protected SweeperProducer producer;

    public OneRunBatchRunner(File scenarioDir) throws ScenarioLoadException {
        BatchScheduleRunner scheduleRunner = new BatchScheduleRunner();
        scheduleRunner.addRunListener((RunListener)this);
        this.runEnvironmentBuilder = new DefaultRunEnvironmentBuilder((Runner)scheduleRunner, true);
        this.controller = new ORBController(this.runEnvironmentBuilder);
        this.controller.setScheduleRunner((Runner)scheduleRunner);
        this.init(scenarioDir);
    }

    private void init(File scenarioDir) throws ScenarioLoadException {
        if (scenarioDir.exists()) {
            ScenarioLoader loader = this.createScenarioLoader(scenarioDir);
            ControllerRegistry registry = loader.load(this.runEnvironmentBuilder);
            this.controller.setControllerRegistry(registry);
        } else {
            msgCenter.error((Object)"Scenario not found", (Throwable)new IllegalArgumentException("Invalid scenario " + scenarioDir.getAbsolutePath()), new Object[0]);
        }
    }

    private ScenarioLoader createScenarioLoader(File scenarioDir) {
        InputStream in = this.getClass().getResourceAsStream("batch.properties");
        Properties props = new Properties();
        try {
            props.load(in);
            in.close();
            String className = props.getProperty("batch.scenario.loader", "repast.simphony.batch.BatchScenarioLoader");
            Class<?> clazz = Class.forName(className, true, this.getClass().getClassLoader());
            Constructor<?> constructor = clazz.getConstructor(File.class);
            ScenarioLoader scenarioLoader = (ScenarioLoader)constructor.newInstance(scenarioDir);
            return scenarioLoader;
        }
        catch (IOException | ClassCastException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            msgCenter.warn((Object)"Unable to find batch loader class in batch.properties file. Using default loader.", (Throwable)ex, new Object[0]);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new BatchScenarioLoader(scenarioDir);
    }

    public void batchInit() {
        this.controller.batchInitialize();
    }

    public void batchCleanup() {
        this.controller.batchCleanup();
    }

    public void run(int runNum, Parameters params) {
        this.pause = true;
        params = this.setupSweep(params);
        this.controller.runParameterSetters(params);
        this.controller.setRunNumber(runNum);
        this.controller.runInitialize(params);
        this.controller.execute();
        this.waitForRun();
        this.controller.runCleanup();
    }

    protected boolean keepRunning() {
        for (ParameterSetter setter : this.controller.getControllerRegistry().getParameterSetters()) {
            if (setter.atEnd()) continue;
            return true;
        }
        return false;
    }

    private Parameters setupSweep(Parameters params) {
        if (!params.getSchema().contains("randomSeed")) {
            ParametersCreator creator = new ParametersCreator();
            creator.addParameters(params);
            creator.addParameter("randomSeed", Integer.class, (Object)((int)System.currentTimeMillis()), false);
            params = creator.createParameters();
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRun() {
        Object object = this.monitor;
        synchronized (object) {
            while (this.pause) {
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyMonitor() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public void paused() {
    }

    public void restarted() {
    }

    public void started() {
    }

    public void stopped() {
        this.pause = false;
        this.notifyMonitor();
    }

    private static class ORBController
    extends DefaultController {
        private int runNumber;

        public ORBController(RunEnvironmentBuilder runEnvironmentBuilder) {
            super(runEnvironmentBuilder);
        }

        public void setRunNumber(int runNumber) {
            this.runNumber = runNumber;
        }

        protected boolean prepare() {
            boolean retVal = super.prepare();
            this.getCurrentRunState().getRunInfo().setRunNumber(this.runNumber);
            return retVal;
        }

        protected void prepareForNextRun() {
            super.prepareForNextRun();
            this.getCurrentRunState().getRunInfo().setRunNumber(this.runNumber);
        }
    }
}

